/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeVO;
import com.inet.helpdesk.plugins.inventory.server.webapi.data.InventoryAssetEntry;
import com.inet.id.GUID;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@JsonData
@Schema(description="Response data for an inventory asset search query")
public class InventorySearchResponse {
    @Schema(description="Whether there are more results available beyond the current chunk")
    private boolean isPartialResult;
    @Schema(description="List of matching asset entries")
    private List<InventoryAssetEntry> entries = new ArrayList<InventoryAssetEntry>();

    public static InventorySearchResponse from(List<GUID> entries, boolean partialResult) {
        InventorySearchResponse response = new InventorySearchResponse();
        response.isPartialResult = partialResult;
        AssetManager assetManager = AssetManager.getInstance();
        AssetTypeManager assetTypeManager = AssetTypeManager.getInstance();
        HashMap<Integer, AssetTypeVO> knowAssetTypes = new HashMap<Integer, AssetTypeVO>();
        List<AssetView> assets = assetManager.getAssets(entries, true);
        for (AssetView asset : assets) {
            if (asset == null) continue;
            AssetTypeVO type = knowAssetTypes.computeIfAbsent(asset.getType(), e -> (AssetTypeVO)assetTypeManager.get((int)e));
            InventoryAssetEntry entry = InventoryAssetEntry.from(asset, type).addOwner(asset);
            response.entries.add(entry);
        }
        return response;
    }
}

