/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.helpdesk.plugins.inventory.client.InventoryAttachments;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeVO;
import com.inet.helpdesk.plugins.inventory.server.webapi.data.InventoryAssetEntry;
import com.inet.helpdesk.plugins.inventory.server.webapi.util.InventoryWebAPIHelper;
import com.inet.plugin.ServerPluginManager;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@JsonData
@Schema(description="Response data containing detailed information about an inventory asset")
public class InventoryAssetResponse
extends InventoryAssetEntry {
    private static List<@Nonnull String> KEYS_TO_EXCLUDE = Arrays.asList(AssetFields.FIELD_TYPE.getKey(), AssetFields.FIELD_PARENT.getKey(), AssetFields.FIELD_IMAGE.getKey());
    @Schema(description="Whether the asset has any attachments")
    @JsonExcludeNull
    private boolean hasAttachments;
    @Schema(description="Map of field keys to their values for the asset, excluding type, parent, and image fields")
    private Map<String, Object> fields = new HashMap<String, Object>();

    public static InventoryAssetResponse from(AssetView asset) {
        InventoryAssetResponse response = new InventoryAssetResponse();
        response.fillWith(asset);
        AssetTypeVO assetTypeVO = (AssetTypeVO)AssetTypeManager.getInstance().get(asset.getType());
        List<AssetFieldDefinition> fields = InventoryWebAPIHelper.getAvailableAssetFields(assetTypeVO);
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            response.hasAttachments = InventoryAttachments.getAttachments(asset.getId()).size() > 0;
        }
        for (AssetFieldDefinition definition : fields) {
            Object value;
            AssetField assetField;
            String key = definition.getFieldKey();
            if (KEYS_TO_EXCLUDE.contains(key) || (assetField = AssetFields.getFieldFor(key)) == null || (value = asset.getValue(assetField)) == null) continue;
            response.fields.put(key, value);
        }
        return response;
    }
}

