/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.http.upload.AttachmentDescription;
import com.inet.lib.util.EncodingFunctions;
import io.swagger.v3.oas.annotations.media.Schema;

@JsonData
@Schema(description="Description of an attachment associated with an inventory asset")
public class InventoryAssetAttachmentDescription
extends AttachmentDescription {
    @Schema(description="The size of the attachment file in bytes")
    private long fileLength;
    @Schema(description="The relative URL to access this attachment")
    private String url;

    public InventoryAssetAttachmentDescription(AttachmentRow attachment) {
        super(attachment.getFileName(), attachment.getLastModified(), null);
        this.url = EncodingFunctions.encodeUrlPath((String)AttachmentFilePathBuilder.getRestfulPath((AttachmentKey)attachment.getAttachmentKey()));
        this.fileLength = attachment.getFileLength();
    }
}

