/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.asset;

import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.helpdesk.plugins.inventory.server.webapi.InventoryWebAPIExtension;
import com.inet.helpdesk.plugins.inventory.server.webapi.data.InventoryAssetResponse;
import com.inet.helpdesk.plugins.inventory.server.webapi.util.InventoryWebAPIHelper;
import com.inet.http.ClientMessageException;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="Inventory", description="Operations for managing inventory assets")
public class InventoryCreateAssetHandler
extends RequestHandler<Map<String, Object>, InventoryAssetResponse> {
    public InventoryCreateAssetHandler() {
        super(new String[]{"create"});
    }

    public String getHelpPageKey() {
        return "webapi.inventory.create";
    }

    @Operation(summary="Create a new asset", description="Creates a new asset in the inventory with the specified data. Requires write permissions.", responses={@ApiResponse(responseCode="200", description="Asset created successfully", content={@Content(schema=@Schema(implementation=InventoryAssetResponse.class))}), @ApiResponse(responseCode="400", description="Invalid or missing asset data"), @ApiResponse(responseCode="401", description="User not authorized"), @ApiResponse(responseCode="403", description="User does not have write permissions")})
    public InventoryAssetResponse handle(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Parameter(description="Asset data for creation", required=true) @Nullable Map<String, Object> creationData, boolean previewModeEnabled) throws IOException {
        if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_READ_WRITE)) {
            throw new AccessDeniedException(InventoryServerPlugin.INVENTORY_READ_WRITE);
        }
        if (creationData == null) {
            throw new ClientMessageException(InventoryWebAPIExtension.MSG.getMsg("asset.create.dataMissing", new Object[0]));
        }
        AssetManager manager = AssetManager.getInstance();
        MutableAssetData dataToChange = InventoryWebAPIHelper.prepareAssetData(creationData, null);
        if (dataToChange.isEmpty()) {
            throw new ClientMessageException(InventoryWebAPIExtension.MSG.getMsg("asset.create.dataMissing", new Object[0]));
        }
        if (previewModeEnabled) {
            return null;
        }
        List<AssetManager.AdditionalTask> extensionTasks = InventoryWebAPIHelper.checkAttachmentsUpdateRequest(request, creationData);
        AssetView asset = manager.createAsset(dataToChange, extensionTasks);
        return InventoryAssetResponse.from(asset);
    }

    public boolean isMethodAllowedForData(HttpServletRequest request) {
        return "POST".equals(request.getMethod()) || "PUT".equals(request.getMethod());
    }
}

