/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.taskplanner.series.devicewarranty;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeVO;
import com.inet.helpdesk.plugins.inventory.server.taskplanner.i18n.InventoryTaskPlannerMsg;
import com.inet.helpdesk.plugins.inventory.server.taskplanner.series.devicewarranty.DeviceWarrantyEndApproachingSeries;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.SelectInputField;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.taskplanner.server.api.series.SeriesFactory;
import com.inet.taskplanner.server.api.series.SeriesInfo;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DeviceWarrantyEndApproachingSeriesFactory
extends SeriesFactory<DeviceWarrantyEndApproachingSeries> {
    public static final String PROPERTY_DEVICE_TYPE_FILTER = "deviceTypeFilter";
    public static final String PROPERTY_WHICH_FIELD = "whichField";
    public static final String PROPERTY_BEFORE_OR_AFTER = "beforeOrAfter";
    public static final String PROPERTY_BEFORE = "before";
    public static final String PROPERTY_AFTER = "after";
    public static final String PROPERTY_BETWEEN = "between";
    public static final String PROPERTY_TIME_1 = "warrantytime";
    public static final String PROPERTY_TIME_2 = "warrantytime2";
    public static final String EXTENSION_NAME = "series.helpdesk.devicewarrantyendapproaching";
    private static final Map<String, Integer> WEEK_KEY_TO_DISPLAY_STRING = new HashMap<String, Integer>(){
        {
            this.put("1week", 1);
            this.put("2week", 2);
            this.put("3week", 3);
            this.put("4week", 4);
            this.put("5week", 5);
            this.put("6week", 6);
            this.put("7week", 7);
            this.put("8week", 8);
            this.put("atexecution", 0);
            this.put("1weekago", 1);
            this.put("2weekago", 2);
            this.put("3weekago", 3);
            this.put("4weekago", 4);
            this.put("5weekago", 5);
            this.put("6weekago", 6);
            this.put("7weekago", 7);
            this.put("8weekago", 8);
        }
    };
    public static final String KEY_DEVICE_NAME = "Device-Name";
    public static final String KEY_DEVICE_ID = "Device-ID";

    public DeviceWarrantyEndApproachingSeriesFactory() {
        super(EXTENSION_NAME);
    }

    public SeriesInfo getInformation(@Nullable GUID guid) {
        ArrayList<Object> fields = new ArrayList<Object>();
        List assetFieldDefinitions = DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class);
        ArrayList whichFieldChoices = assetFieldDefinitions.stream().filter(d -> d.getDisplayType() == FieldSettingsType.TYPE_DATE || d.getDisplayType() == FieldSettingsType.TYPE_DATE_TIME).map(d -> new LocalizedKey(d.getFieldKey(), d.getLabel())).collect(Collectors.toCollection(ArrayList::new));
        SelectField whichField = new SelectField(PROPERTY_WHICH_FIELD, InventoryTaskPlannerMsg.MSG.getMsg("whichfield", new Object[0]), whichFieldChoices);
        whichField.setValue(AssetFields.FIELD_WARRANTY.getFieldKey());
        fields.add(whichField);
        SelectField beforeOrAfter = new SelectField(PROPERTY_BEFORE_OR_AFTER, InventoryTaskPlannerMsg.MSG.getMsg("beforeorafter", new Object[0]), (ArrayList)new ArrayList<LocalizedKey>(){
            {
                this.add(new LocalizedKey(DeviceWarrantyEndApproachingSeriesFactory.PROPERTY_BEFORE, InventoryTaskPlannerMsg.MSG.getMsg("beforeorafter.before", new Object[0])));
                this.add(new LocalizedKey(DeviceWarrantyEndApproachingSeriesFactory.PROPERTY_AFTER, InventoryTaskPlannerMsg.MSG.getMsg("beforeorafter.after", new Object[0])));
                this.add(new LocalizedKey(DeviceWarrantyEndApproachingSeriesFactory.PROPERTY_BETWEEN, InventoryTaskPlannerMsg.MSG.getMsg("beforeorafter.between", new Object[0])));
            }
        });
        beforeOrAfter.setValue(PROPERTY_BEFORE);
        fields.add(beforeOrAfter);
        ArrayList<LocalizedKey> values = new ArrayList<LocalizedKey>();
        values.add(new LocalizedKey("8week", InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.weeks", new Object[]{8})));
        values.add(new LocalizedKey("7week", InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.weeks", new Object[]{7})));
        values.add(new LocalizedKey("6week", InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.weeks", new Object[]{6})));
        values.add(new LocalizedKey("5week", InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.weeks", new Object[]{5})));
        values.add(new LocalizedKey("4week", InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.weeks", new Object[]{4})));
        values.add(new LocalizedKey("3week", InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.weeks", new Object[]{3})));
        values.add(new LocalizedKey("2week", InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.weeks", new Object[]{2})));
        values.add(new LocalizedKey("1week", InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.weeks", new Object[]{1})));
        values.add(new LocalizedKey("atexecution", InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.weeks", new Object[]{0})));
        values.add(new LocalizedKey("1weekago", InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.weeksAgo", new Object[]{1})));
        values.add(new LocalizedKey("2weekago", InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.weeksAgo", new Object[]{2})));
        values.add(new LocalizedKey("3weekago", InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.weeksAgo", new Object[]{3})));
        values.add(new LocalizedKey("4weekago", InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.weeksAgo", new Object[]{4})));
        values.add(new LocalizedKey("5weekago", InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.weeksAgo", new Object[]{5})));
        values.add(new LocalizedKey("6weekago", InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.weeksAgo", new Object[]{6})));
        values.add(new LocalizedKey("7weekago", InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.weeksAgo", new Object[]{7})));
        values.add(new LocalizedKey("8weekago", InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.weeksAgo", new Object[]{8})));
        SelectField selectField = new SelectField(PROPERTY_TIME_1, "", values);
        selectField.setValue("2week");
        fields.add(selectField);
        SelectField selectField2 = new SelectField(PROPERTY_TIME_2, InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.weeksLabel.and", new Object[0]), values);
        selectField2.setValue("2week");
        selectField2.setConditions(Arrays.asList(FieldCondition.visible((Field)beforeOrAfter, (FieldCondition.OP)FieldCondition.OP.equals, (String)PROPERTY_BETWEEN)));
        fields.add(selectField2);
        SelectInputField deviceTypeFilter = new SelectInputField(PROPERTY_DEVICE_TYPE_FILTER, InventoryTaskPlannerMsg.MSG.getMsg("DeviceTypeFilter", new Object[0]), 14);
        deviceTypeFilter.setValue("");
        deviceTypeFilter.setDisplay(InventoryTaskPlannerMsg.MSG.getMsg("WorkflowFilter.any", new Object[0]));
        fields.add(deviceTypeFilter);
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/images/expwarranty_32.png");
        return new SeriesInfo(this.getExtensionName(), InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.name", new Object[0]), InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.description", new Object[0]), iconURL, "taskplanner.series.warranty", fields);
    }

    public void validate(@Nonnull SeriesDefinition definition, GUID guid) throws ValidationException {
        String tim2;
        String tim1;
        if (PROPERTY_BETWEEN.equals(definition.getProperty(PROPERTY_BEFORE_OR_AFTER)) && Objects.equals(tim1 = definition.getProperty(PROPERTY_TIME_1), tim2 = definition.getProperty(PROPERTY_TIME_2))) {
            throw new ValidationException(new String[]{InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.betweenError", new Object[0])});
        }
    }

    public SummaryInfo getSummary(@Nonnull SeriesDefinition definition) {
        Object entryValue;
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        String warrantytime = definition.getProperty(PROPERTY_TIME_1);
        Integer howManyWeeks = WEEK_KEY_TO_DISPLAY_STRING.get(warrantytime);
        String deviceTypeFilter = definition.getProperty(PROPERTY_DEVICE_TYPE_FILTER);
        String detailText = InventoryTaskPlannerMsg.MSG.getMsg(warrantytime.endsWith("ago") ? "DeviceWarrantyEndApproaching.weeksAgo" : "DeviceWarrantyEndApproaching.weeks", new Object[]{howManyWeeks});
        String warrantytime2 = definition.getProperty(PROPERTY_TIME_2);
        Integer howManyWeeks2 = WEEK_KEY_TO_DISPLAY_STRING.get(warrantytime2 == null || warrantytime2.isBlank() ? "0" : warrantytime2);
        String detailText2 = InventoryTaskPlannerMsg.MSG.getMsg(warrantytime2 != null && warrantytime2.endsWith("ago") ? "DeviceWarrantyEndApproaching.weeksAgo" : "DeviceWarrantyEndApproaching.weeks", new Object[]{howManyWeeks2});
        List assetFieldDefinitions = DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class);
        String whichfield = definition.getProperty(PROPERTY_WHICH_FIELD);
        if (whichfield == null) {
            whichfield = AssetFields.FIELD_WARRANTY.getFieldKey();
        }
        String whichfield_ = whichfield;
        String whichfieldLabel = assetFieldDefinitions.stream().filter(d -> d.getFieldKey().equals(whichfield_)).findFirst().map(f -> f.getLabel()).orElse(AssetFields.FIELD_WARRANTY.getLabel());
        String beforeOrAfter = definition.getProperty(PROPERTY_BEFORE_OR_AFTER);
        String baseKey = PROPERTY_BEFORE.equals(beforeOrAfter) ? "DeviceWarrantyEndApproaching.beforeDeviceWarrantyExpires" : (PROPERTY_AFTER.equals(beforeOrAfter) ? "DeviceWarrantyEndApproaching.afterDeviceWarrantyExpires" : "DeviceWarrantyEndApproaching.betweenDeviceWarrantyExpires");
        Object object = entryValue = PROPERTY_BETWEEN.equals(beforeOrAfter) ? InventoryTaskPlannerMsg.MSG.getMsg(baseKey, new Object[]{whichfieldLabel, detailText, detailText2}) : InventoryTaskPlannerMsg.MSG.getMsg(baseKey, new Object[]{whichfieldLabel, detailText});
        if (deviceTypeFilter != null && !"".equals(deviceTypeFilter)) {
            Integer filterType = Integer.valueOf(deviceTypeFilter);
            AssetTypeVO assetTypeVO = (AssetTypeVO)AssetTypeManager.getInstance().get(filterType);
            String typeDisplay = assetTypeVO == null ? InventoryTaskPlannerMsg.MSG.getMsg("deleted", new Object[0]) : assetTypeVO.getDisplayValue();
            entryValue = (String)entryValue + " " + InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyEndApproaching.WithType", new Object[]{typeDisplay});
        }
        summary.add(new SummaryEntry("", (String)entryValue));
        return new SummaryInfo(summary);
    }

    protected DeviceWarrantyEndApproachingSeries createInstanceFrom(@Nonnull SeriesDefinition definition, @Nullable GUID taskID) {
        return new DeviceWarrantyEndApproachingSeries(taskID, definition.getUid(), definition.getProperty(PROPERTY_WHICH_FIELD), definition.getProperty(PROPERTY_BEFORE_OR_AFTER), definition.getProperty(PROPERTY_TIME_1), definition.getProperty(PROPERTY_TIME_2), definition.getProperty(PROPERTY_DEVICE_TYPE_FILTER));
    }

    @Nonnull
    public Set<String> getKeys(@Nonnull SeriesDefinition definition) {
        HashSet<String> result = new HashSet<String>();
        result.add(KEY_DEVICE_ID);
        result.add(KEY_DEVICE_NAME);
        List fieldDefinitions = DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class);
        fieldDefinitions.stream().forEach(d -> {
            String fieldKey = d.getFieldKey();
            result.add("asset." + fieldKey);
        });
        return result;
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }
}

