/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.plugin.setup;

import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetDataCache;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetManagerImpl;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepExecutionProgressInfo;
import com.inet.setupwizard.api.StepKey;
import com.inet.shared.utils.Version;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class MigrateInheritableFieldsStep
extends AutoSetupStep {
    public static final StepKey KEY = new StepKey("migrateinheritableFields");
    private int numOfCheckedAssets;

    public StepKey stepKey() {
        return KEY;
    }

    public String getStepDisplayName() {
        return AssetManager.MSG.getMsg("setup.database.migrateinheritance", new Object[0]);
    }

    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> AssetManager.MSG.getMsg("setup.database.migrateinheritance.info", new Object[0]);
    }

    public boolean hasPendingTasks() {
        Configuration c = ConfigurationManager.getInstance().getCurrent();
        return "true".equalsIgnoreCase(c.get("geraete.vererbung"));
    }

    @Nullable
    public Version getMigrationVersion() {
        Version lastMigratedHDVersion = MigrateInheritableFieldsStep.getLastMigratedVersionOf((String)"helpdesk");
        if (lastMigratedHDVersion != null && new Version("23.10").isHigherThan(lastMigratedHDVersion)) {
            return null;
        }
        return new Version("23.10");
    }

    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        AssetDataCache cache = ((AssetManagerImpl)AssetManager.getInstance()).getDataCache();
        this.numOfCheckedAssets = 0;
        try (UserAccountScope p = UserAccountScope.createPrivileged();){
            Iterator<GUID> iterator = cache.iterator();
            while (iterator.hasNext()) {
                UserAccount owner;
                GUID assetId = iterator.next();
                AssetView assetView = cache.get(assetId);
                ++this.numOfCheckedAssets;
                this.getStepExecutionProgressListener().progressInfoUpdated(new StepExecutionProgressInfo(0, () -> "Asset " + this.numOfCheckedAssets));
                if (assetView == null || assetView.getValue(AssetFields.FIELD_OWNER) == null || (owner = UserManager.getInstance().getUserAccount(assetView.getValue(AssetFields.FIELD_OWNER))) == null) continue;
                MutableAssetData fieldsToDrop = new MutableAssetData();
                if (Objects.equals(assetView.getValue(AssetFields.FIELD_ROOM), owner.getValue((UserField)HDUsersAndGroups.FIELD_ROOM))) {
                    fieldsToDrop.put(AssetFields.FIELD_ROOM, null);
                }
                if (Objects.equals(assetView.getValue(AssetFields.FIELD_COSTCENTER), owner.getValue((UserField)HDUsersAndGroups.FIELD_COST_CENTRE))) {
                    fieldsToDrop.put(AssetFields.FIELD_COSTCENTER, null);
                }
                if (Objects.equals(assetView.getValue(AssetFields.FIELD_LOCATION), owner.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID))) {
                    fieldsToDrop.put(AssetFields.FIELD_LOCATION, null);
                }
                if (fieldsToDrop.isEmpty()) continue;
                AssetManager.getInstance().updateAsset(assetId, fieldsToDrop);
            }
        }
    }

    public SetupStepPriority getPriority() {
        return new SetupStepPriority(5613);
    }
}

