/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.plugin.setup;

import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.DBUpdateBackdoor;
import com.inet.helpdesk.core.utils.DatabaseVersionChecker;
import com.inet.helpdesk.plugins.inventory.client.data.InventoryTreeGroupEntry;
import com.inet.helpdesk.plugins.inventory.client.handler.LoadTreeGroupingSettings;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.license.AssetLicense;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.license.AssetLicenseManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.sla.AssetSLA;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.sla.AssetSLAManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeVO;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.vendor.AssetVendor;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.vendor.AssetVendorManager;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.helpdesk.plugins.setupwizard.steps.database.DatabaseConnectionFactory;
import com.inet.helpdesk.plugins.setupwizard.steps.database.HdDatabaseCheck;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepExecutionProgressInfo;
import com.inet.setupwizard.api.StepKey;
import com.inet.shared.utils.Version;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.SQLException;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InventoryDatabaseStep
extends AutoSetupStep {
    public StepKey stepKey() {
        return new StepKey("InventoryDatabase");
    }

    public String getStepDisplayName() {
        return AssetManager.MSG.getMsg("setup.database.displayname", new Object[0]);
    }

    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> AssetManager.MSG.getMsg("setup.database.displayname", new Object[0]);
    }

    public boolean hasPendingTasks() {
        boolean databaseStructureChanged = new DatabaseVersionChecker().isDatabaseStructureChanged(InventoryServerPlugin.class);
        if (databaseStructureChanged) {
            return true;
        }
        String dbConfigs = ConfigurationManager.getInstance().getCurrent().get(HDConfigKeys.DB_CONFIGS.getKey());
        if (dbConfigs == null || dbConfigs.isEmpty()) {
            return true;
        }
        DatabaseConfigInfoList list = (DatabaseConfigInfoList)new Json().fromJson(dbConfigs, DatabaseConfigInfoList.class);
        DatabaseConfigInfo dbInfo = list.get("HDS");
        if (dbInfo == null) {
            return true;
        }
        try {
            if (HdDatabaseCheck.tableExists((DatabaseConnectionFactory)((DatabaseConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(DatabaseConnectionFactory.class)), (String)"tblGeraeteBestand")) {
                return false;
            }
        }
        catch (SQLException t) {
            SetupLogger.LOGGER.debug((Object)t);
            return true;
        }
        catch (Throwable e) {
            SetupLogger.LOGGER.error(e);
            return true;
        }
        return true;
    }

    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        String dbConfigs = ConfigurationManager.getInstance().getCurrent().get(HDConfigKeys.DB_CONFIGS.getKey());
        DatabaseConfigInfoList list = (DatabaseConfigInfoList)new Json().fromJson(dbConfigs, DatabaseConfigInfoList.class);
        DatabaseConfigInfo dbInfo = list.get("HDS");
        try {
            DBUpdateBackdoor dbUpdater = (DBUpdateBackdoor)ServerPluginManager.getInstance().getSingleInstance(DBUpdateBackdoor.class);
            dbUpdater.updateDB(dbInfo, InventoryServerPlugin.class, null, null, event -> this.getStepExecutionProgressListener().progressInfoUpdated(new StepExecutionProgressInfo(5, () -> event.getCurrentJobName(ClientLocale.getThreadLocale()))));
            new DatabaseVersionChecker().markDatabaseStructureChanged(InventoryServerPlugin.class);
        }
        catch (Throwable t) {
            throw new StepExecutionException(t);
        }
        Version lastMigratedVersionOfThisPlugin = this.getLastMigratedVersionOfThisPlugin();
        SetupLogger.LOGGER.info((Object)("[Inventory] last version is " + String.valueOf(lastMigratedVersionOfThisPlugin)));
        if (this.inventoryIsEmpty()) {
            this.createSampleAssets();
        }
        if (lastMigratedVersionOfThisPlugin == null || new Version("23.10").isHigherThan(lastMigratedVersionOfThisPlugin)) {
            this.migrateOldCustomGroupingColumn();
            this.grantInventoryALLToUsersWithInventoryAccess();
        }
    }

    private boolean inventoryIsEmpty() {
        AssetTypeManager typeManager = AssetTypeManager.getInstance();
        return typeManager.getAll(false).isEmpty();
    }

    private void grantInventoryALLToUsersWithInventoryAccess() {
        Set users = UserManager.getInstance().getSearchEngine().simpleSearch(new SearchCommand(new SearchExpression[]{new SearchCondition("permissions", SearchCondition.SearchTermOperator.Equals, (Object)InventoryServerPlugin.INVENTORY_READ.getKey())}));
        SetupLogger.LOGGER.info((Object)("[Inventory] found " + users.size() + " users to update"));
        for (GUID iserId : users) {
            UserAccount userAccount = UserManager.getInstance().getUserAccount(iserId);
            if (userAccount == null || userAccount.getAccountType() == UserAccountType.Administrator) continue;
            UserManager.getInstance().updateUserPermissions(iserId, Set.of(InventoryServerPlugin.INVENTORY_ALL), Set.of());
        }
        for (UserGroupInfo groupInfo : UserGroupManager.getInstance().getAllGroups()) {
            if (!groupInfo.getPermissions().contains(InventoryServerPlugin.INVENTORY_READ)) continue;
            UserGroupManager.getInstance().updateGroupPermissions(groupInfo.getID(), Set.of(InventoryServerPlugin.INVENTORY_ALL), Set.of());
        }
    }

    private void migrateOldCustomGroupingColumn() {
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        String extraColumn = configuration.get("AdditionalDeviceColumn");
        if (StringFunctions.isEmpty((String)extraColumn)) {
            return;
        }
        try {
            int i = Integer.valueOf(extraColumn.substring(6));
            if (i != 1) {
                List list = (List)LoadTreeGroupingSettings.GROUPING_LIST.get();
                InventoryTreeGroupEntry groupEntry = new InventoryTreeGroupEntry("Benutzerdefiniertes Feld " + i);
                groupEntry.setGroupingKeys(List.of("custom" + i));
                list.add(groupEntry);
                configuration.put(InventoryServerPlugin.CONFIGKEY_GROUPING, new Json().toJson((Object)list));
            }
        }
        catch (IndexOutOfBoundsException | NumberFormatException ex) {
            SetupLogger.LOGGER.warn((Object)("[Inventory] Cannot migrate AdditionalDeviceColumn. Invalid value:" + extraColumn));
        }
    }

    private void createSampleAssets() throws StepExecutionException {
        AssetTypeManager typeManager = AssetTypeManager.getInstance();
        if (!typeManager.getAll(false).isEmpty()) {
            SetupLogger.LOGGER.info((Object)"Do not create inventory sample data because there are alredy assets in database.");
            return;
        }
        try (UserAccountScope pr = UserAccountScope.createPrivileged();){
            int typeComputer = typeManager.add(new AssetTypeVO("Computer", "computer.gif"));
            int typeDrucker = typeManager.add(new AssetTypeVO("Drucker", "drucken.gif"));
            int typeTFT = typeManager.add(new AssetTypeVO("TFT-Display", "monitor.gif"));
            typeManager.add(new AssetTypeVO("Smartphone", "smartphone.gif"));
            typeManager.add(new AssetTypeVO("Fax", "fax.gif"));
            typeManager.add(new AssetTypeVO("Switch", "switch.gif"));
            typeManager.add(new AssetTypeVO("DVD Brenner", "brenner.gif"));
            typeManager.add(new AssetTypeVO("Scanner", "scanner.gif"));
            typeManager.add(new AssetTypeVO("Kopierer", "scanner.gif"));
            typeManager.add(new AssetTypeVO("Netbook", "laptop.gif"));
            int typeNotebook = typeManager.add(new AssetTypeVO("Notebook", "laptop.gif"));
            int typeSoftware = typeManager.add(new AssetTypeVO("Software", "software.gif"));
            typeManager.add(new AssetTypeVO("USV", "usv.gif"));
            typeManager.add(new AssetTypeVO("Router", "router.gif"));
            AssetVendorManager vendorManager = AssetVendorManager.getInstance();
            int vendor = vendorManager.add(new AssetVendor(-1, "Tech Data", "089/4700-0", "easy@techdata.de", "089/4700-3009", "Tech Data GmbH & Co. OHG\r\nGesch\u00e4ftsbereich Tech Data Deutschland\r\nKistlerhofstrasse 75 \r\n81379 M\u00fcnchen", "So erhalten Sie Ihre automatisierte Retourenautorisierung \u00fcber e-RMA:\r\nhttp://transfer.techdata.de/tools/media/erma_hilfe/eRMA_Hilfe.htm\r\n * falsche Lieferung oder Ware einfach zur\u00fcckgeben\r\n * defekte Ware, Garantie- und Gew\u00e4hrleistungsf\u00e4lle", false));
            AssetSLAManager slaManager = AssetSLAManager.getInstance();
            int sla1 = slaManager.add(new AssetSLA(-1, "Drucker Hauptverwaltung", "Alle Drucker in der Hauptverwaltung werden durch die Servicefirma DEBZ betreut.", null, false));
            int sla2 = slaManager.add(new AssetSLA(-1, "Hauptverwaltung", "In der Hauptverwaltung werden alle Ger\u00e4te, au\u00dfer den Druckern, durch unsere EDV Abteilung betreut.", null, false));
            slaManager.add(new AssetSLA(-1, "Zweigstelle", "In der Zweigstelle erfolgt die Betreuung durch den \"First Level Support\".\n\rAu\u00dfer am Wochenende: F\u00fcr dringende F\u00e4lle ist die Firma ZDV zust\u00e4ndig.", 2, false));
            slaManager.add(new AssetSLA(-1, "Entwicklung", "Die Entwicklung wird durch die Firma DEBZ betreut.", null, false));
            AssetLicenseManager licenseManager = AssetLicenseManager.getInstance();
            int licenseId = licenseManager.add(new AssetLicense(-1, "Office Professional Plus 2013", "Open License (Open C)", "Office Professional Plus 2013", "Volumenlizenzprogramm", new GregorianCalendar(2015, 11, 15).getTimeInMillis(), 0, 0, false));
            MutableAssetData data = new MutableAssetData();
            data.put(AssetFields.FIELD_NAME, "Dell Desktop OptiPlex 7020 Micro");
            data.put(AssetFields.FIELD_TYPE, typeComputer);
            data.put(AssetFields.FIELD_PURCHASE_DATE, new GregorianCalendar(2015, 11, 30).getTimeInMillis());
            data.put(AssetFields.FIELD_PRICE, 669.0);
            data.put(AssetFields.FIELD_SERIAL_NUMBER, "X987Y65");
            data.put(AssetFields.FIELD_ASSET_NUMBER, "003579");
            data.put(AssetFields.FIELD_LOCATION, 0);
            data.put(AssetFields.FIELD_SLA, sla2);
            data.put(AssetFields.FIELD_WARRANTY, new GregorianCalendar(2017, 11, 30).getTimeInMillis());
            data.put(AssetFields.FIELD_VENDOR, vendor);
            data.put(AssetFields.FIELD_COSTCENTER, "080");
            data.put(AssetFields.getFieldFor("custom1"), "10.234.1.7");
            GUID computerId = AssetManager.getInstance().createAsset(data).getId();
            data = new MutableAssetData();
            data.put(AssetFields.FIELD_NAME, "Office Professional Plus 2013");
            data.put(AssetFields.FIELD_TYPE, typeSoftware);
            data.put(AssetFields.FIELD_PURCHASE_DATE, new GregorianCalendar(2015, 11, 30).getTimeInMillis());
            data.put(AssetFields.FIELD_PRICE, 0.0);
            data.put(AssetFields.FIELD_LOCATION, 0);
            data.put(AssetFields.FIELD_ROOM, "E.10");
            data.put(AssetFields.FIELD_WARRANTY, new GregorianCalendar(2017, 11, 30).getTimeInMillis());
            data.put(AssetFields.FIELD_VENDOR, vendor);
            data.put(AssetFields.FIELD_LICENSE, licenseId);
            data.put(AssetFields.FIELD_PARENT, computerId);
            AssetManager.getInstance().createAsset(data);
            data = new MutableAssetData();
            data.put(AssetFields.FIELD_NAME, "Dell UltraSharp 24 \u2013 U2415");
            data.put(AssetFields.FIELD_TYPE, typeTFT);
            data.put(AssetFields.FIELD_PURCHASE_DATE, new GregorianCalendar(2015, 11, 30).getTimeInMillis());
            data.put(AssetFields.FIELD_PRICE, 248.0);
            data.put(AssetFields.FIELD_SERIAL_NUMBER, "CN-OY323G-74261-915-G4ES");
            data.put(AssetFields.FIELD_ASSET_NUMBER, "006421");
            data.put(AssetFields.FIELD_LOCATION, 0);
            data.put(AssetFields.FIELD_ROOM, "E.10");
            data.put(AssetFields.FIELD_SLA, sla2);
            data.put(AssetFields.FIELD_WARRANTY, new GregorianCalendar(2017, 11, 30).getTimeInMillis());
            data.put(AssetFields.FIELD_VENDOR, vendor);
            data.put(AssetFields.FIELD_COSTCENTER, "080");
            data.put(AssetFields.FIELD_PARENT, computerId);
            AssetManager.getInstance().createAsset(data);
            data = new MutableAssetData();
            data.put(AssetFields.FIELD_NAME, "Dell Latitude 14 Ultrabook 7000");
            data.put(AssetFields.FIELD_TYPE, typeNotebook);
            data.put(AssetFields.FIELD_PURCHASE_DATE, new GregorianCalendar(2015, 11, 30).getTimeInMillis());
            data.put(AssetFields.FIELD_PRICE, 1163.0);
            data.put(AssetFields.FIELD_SERIAL_NUMBER, "X987Y65");
            data.put(AssetFields.FIELD_ASSET_NUMBER, "003579");
            data.put(AssetFields.FIELD_LOCATION, 0);
            data.put(AssetFields.FIELD_SLA, sla2);
            data.put(AssetFields.FIELD_WARRANTY, new GregorianCalendar(2017, 11, 30).getTimeInMillis());
            data.put(AssetFields.FIELD_VENDOR, vendor);
            data.put(AssetFields.FIELD_COSTCENTER, "080");
            data.put(AssetFields.getFieldFor("custom1"), "10.234.1.39");
            AssetManager.getInstance().createAsset(data);
            data = new MutableAssetData();
            data.put(AssetFields.FIELD_NAME, "Brother HL-4570CDW");
            data.put(AssetFields.FIELD_TYPE, typeDrucker);
            data.put(AssetFields.FIELD_PURCHASE_DATE, new GregorianCalendar(2015, 11, 30).getTimeInMillis());
            data.put(AssetFields.FIELD_PRICE, 399.0);
            data.put(AssetFields.FIELD_SERIAL_NUMBER, "H15J987654");
            data.put(AssetFields.FIELD_ASSET_NUMBER, "002345");
            data.put(AssetFields.FIELD_LOCATION, 0);
            data.put(AssetFields.FIELD_SLA, sla1);
            data.put(AssetFields.FIELD_WARRANTY, new GregorianCalendar(2017, 11, 30).getTimeInMillis());
            data.put(AssetFields.FIELD_VENDOR, vendor);
            data.put(AssetFields.getFieldFor("custom1"), "080");
            AssetManager.getInstance().createAsset(data);
        }
        catch (SQLException ex) {
            throw new StepExecutionException((Throwable)ex);
        }
    }

    public SetupStepPriority getPriority() {
        return new SetupStepPriority(5610);
    }
}

