/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.plugin.setup;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.utils.TicketValuesImageResolver;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeVO;
import com.inet.helpdesk.plugins.inventory.server.plugin.setup.ImageNameMapper;
import com.inet.helpdesk.plugins.setupwizard.api.HelpDeskSetupModeChecker;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepKey;
import com.inet.shared.utils.Version;
import java.io.InputStream;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class InstallIconsStep
extends AutoSetupStep {
    public static final StepKey KEY = new StepKey("installasseticon");
    HashMap<String, ImageNameMapper> deviceIconMap = new HashMap<String, ImageNameMapper>(){
        {
            this.put("Computer", new ImageNameMapper("computer.gif", "computer_"));
            this.put("Drucker", new ImageNameMapper("drucken.gif", "printer_"));
            this.put("TFT-Display", new ImageNameMapper("monitor.gif", "display_"));
            this.put("Smartphone", new ImageNameMapper("smartphone.gif", "smartphone_"));
            this.put("Fax", new ImageNameMapper("fax.gif", "fax_"));
            this.put("Switch", new ImageNameMapper("switch.gif", "switch_"));
            this.put("DVD Brenner", new ImageNameMapper("brenner.gif", "cd_drive_"));
            this.put("Scanner", new ImageNameMapper("scanner.gif", "scanner_"));
            this.put("Kopierer", new ImageNameMapper("scanner.gif", "copier_"));
            this.put("Netbook", new ImageNameMapper("laptop.gif", "notebook_"));
            this.put("Notebook", new ImageNameMapper("laptop.gif", "notebook_"));
            this.put("Software", new ImageNameMapper("software.gif", "software_"));
            this.put("USV", new ImageNameMapper("usv.gif", "usv_"));
            this.put("Router", new ImageNameMapper("router.gif", "router_"));
        }
    };
    int[] iconSizes = new int[]{16, 24, 32, 48, 64};

    public StepKey stepKey() {
        return KEY;
    }

    public String getStepDisplayName() {
        return AssetManager.MSG.getMsg("setup.installdeviceicon.displayname", new Object[0]);
    }

    public boolean hasPendingTasks() {
        return true;
    }

    public SetupStep.ExecutionRestriction getExecutionRestriction() {
        return SetupStep.ExecutionRestriction.ONCE_PER_SETUP;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        try {
            AssetTypeManager aman = AssetTypeManager.getInstance();
            List allAssets = aman.getAll(false);
            for (AssetTypeVO assetTypeVO : allAssets) {
                String assetName = assetTypeVO.getDisplayValue();
                String assetIcon = assetTypeVO.getSymbol();
                ImageNameMapper imageNameMapper = this.deviceIconMap.get(assetName);
                if (imageNameMapper == null || StringFunctions.isEmpty((String)assetIcon) || !imageNameMapper.getOldName().equalsIgnoreCase(assetIcon)) continue;
                int assetId = assetTypeVO.getId();
                try {
                    String assetImage = "data/14/" + assetId;
                    boolean allIconsExtraced = true;
                    for (int i = 0; i < this.iconSizes.length; ++i) {
                        URL iconUrl = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/plugin/setup/icons/" + imageNameMapper.getNewName() + this.iconSizes[i] + ".png");
                        if (iconUrl == null) {
                            allIconsExtraced = false;
                            HDLogger.error((Object)("InstallIconsStep: Could not load device icon '" + imageNameMapper.getNewName() + this.iconSizes[i] + ".png'"));
                            continue;
                        }
                        try (InputStream openStream = iconUrl.openStream();){
                            byte[] readBytes = IOFunctions.readBytes((InputStream)openStream);
                            TicketValuesImageResolver.getInstance().storeIcon(assetImage, "data:image/png;base64," + Base64.getEncoder().encodeToString(readBytes), this.iconSizes[i]);
                            continue;
                        }
                    }
                    if (!allIconsExtraced) continue;
                    aman.update(new AssetTypeVO(assetId, assetName, assetImage));
                }
                catch (Throwable t) {
                    throw new StepExecutionException(t);
                    return;
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public SetupStepPriority getPriority() {
        return new SetupStepPriority(5620);
    }

    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> AssetManager.MSG.getMsg("setup.installdeviceicon.displayname", new Object[0]);
    }

    @Nullable
    public Version getMigrationVersion() {
        if (this.getLastMigratedVersionOfThisPlugin() == null) {
            return null;
        }
        return ServerPluginManager.getInstance().getPluginDescription("inventory").getVersion();
    }

    public boolean willPerformIrreversibleMigration(EmptyStepConfig settings) {
        Version version = HelpDeskSetupModeChecker.getLastMigratedHelpdeskVersion();
        if (version == null) {
            return false;
        }
        return !version.isHigherThan(new Version("23.10"));
    }
}

