/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.maintenance.cache;

import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.maintenance.cache.InventoryCacheAction;
import com.inet.maintenance.api.cache.MaintenanceCacheAction;
import com.inet.maintenance.api.cache.MaintenanceCacheExtension;
import com.inet.search.index.IndexerStatus;

public class InventoryCacheExtension
implements MaintenanceCacheExtension {
    private InventoryCacheAction action;

    public InventoryCacheExtension(InventoryCacheAction action) {
        this.action = action;
    }

    public MaintenanceCacheAction getCacheAction() {
        return this.action;
    }

    public String getTitle() {
        return AssetManager.MSG.getMsg("maintenance.cache.title", new Object[0]);
    }

    public String getDescription() {
        return AssetManager.MSG.getMsg("maintenance.cache.description", new Object[0]);
    }

    public String getDetailsMessage() {
        IndexerStatus status = this.action.getStatus();
        return AssetManager.MSG.getMsg("maintenance.cache.details", new Object[]{status.getStatistics()});
    }

    public String getDetailsLink() {
        return null;
    }

    public boolean getNeedsPolling() {
        return this.action.getStatus().isRunning();
    }

    public int getProgress() {
        IndexerStatus status = this.action.getStatus();
        long toBeIndexed = status.getToBeIndexed();
        if (status.isRunning()) {
            if (toBeIndexed <= 0L) {
                return 0;
            }
            return (int)(100L * status.getIndexed() / toBeIndexed);
        }
        return -1;
    }
}

