/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model.tree;

import com.inet.id.GUID;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.StringFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AssetNodeIdentifier {
    public static final AssetNodeIdentifier ROOT = new AssetNodeIdentifier();
    @Nullable
    private final GUID assetId;
    @Nonnull
    private List<Grouping> grouping;

    private AssetNodeIdentifier() {
        this.assetId = null;
        this.grouping = Collections.emptyList();
    }

    public AssetNodeIdentifier(GUID assetId) {
        Objects.requireNonNull(assetId);
        this.assetId = assetId;
        this.grouping = Collections.emptyList();
    }

    public AssetNodeIdentifier(String fieldKey, String value) {
        this(Collections.singletonList(new Grouping(fieldKey, value)));
    }

    public AssetNodeIdentifier(AssetNodeIdentifier parent, String fieldKey, String value) {
        Objects.requireNonNull(fieldKey);
        Objects.requireNonNull(parent);
        if (parent.isDevice()) {
            throw new IllegalArgumentException("Parent must be group!");
        }
        this.grouping = new ArrayList<Grouping>();
        this.grouping.addAll(parent.getGrouping());
        this.grouping.add(new Grouping(fieldKey, value));
        this.grouping = Collections.unmodifiableList(this.grouping);
        this.assetId = null;
    }

    public AssetNodeIdentifier(Grouping ... groupings) {
        this(Arrays.asList(groupings));
    }

    public AssetNodeIdentifier(List<Grouping> groupings) {
        Objects.requireNonNull(groupings);
        this.grouping = Collections.unmodifiableList(groupings);
        this.assetId = null;
    }

    public String toString() {
        if (this.isRoot()) {
            return "";
        }
        return this.assetId == null ? "g." + this.grouping.stream().map(Grouping::toString).collect(Collectors.joining(".")) : this.assetId.toString();
    }

    public boolean isRoot() {
        return this.assetId == null && this.grouping.isEmpty();
    }

    public boolean isDevice() {
        return this.assetId != null;
    }

    public List<Grouping> getGrouping() {
        return this.grouping;
    }

    public String getLastFieldKey() {
        return this.grouping.get(this.grouping.size() - 1).getFieldKey();
    }

    public String getLastFieldValue() {
        return this.grouping.get(this.grouping.size() - 1).getFieldValue();
    }

    public static AssetNodeIdentifier valueOf(String identifier) {
        if (StringFunctions.isEmpty((String)identifier)) {
            return ROOT;
        }
        if (identifier.startsWith("g.")) {
            String groupingStr = identifier.substring("g.".length());
            String key = null;
            String value = null;
            int currentIndex = -1;
            ArrayList<Grouping> groupings = new ArrayList<Grouping>();
            while (currentIndex < groupingStr.length()) {
                int next = groupingStr.indexOf(".", currentIndex + 1);
                if (next == -1) {
                    throw new IllegalArgumentException(identifier);
                }
                key = groupingStr.substring(currentIndex + 1, next);
                currentIndex = next;
                if ((next = groupingStr.indexOf(".", currentIndex + 1)) == -1) {
                    next = groupingStr.length();
                }
                value = groupingStr.substring(currentIndex + 1, next);
                key = EncodingFunctions.decodeUrlParameter((String)key);
                value = EncodingFunctions.decodeUrlParameter((String)value);
                groupings.add(new Grouping(key, value));
                currentIndex = next;
            }
            return new AssetNodeIdentifier(groupings);
        }
        return new AssetNodeIdentifier(GUID.valueOf((String)identifier));
    }

    @Nullable
    public GUID getDeviceId() {
        return this.assetId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.assetId == null ? 0 : this.assetId.hashCode());
        result = 31 * result + (this.grouping == null ? 0 : this.grouping.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssetNodeIdentifier other = (AssetNodeIdentifier)obj;
        if (this.assetId == null ? other.assetId != null : !this.assetId.equals((Object)other.assetId)) {
            return false;
        }
        return !(this.grouping == null ? other.grouping != null : !this.grouping.equals(other.grouping));
    }

    @Immutable
    public static class Grouping {
        private final String fieldKey;
        private final String fieldValue;

        public Grouping(String fieldKey, String fieldValue) {
            Objects.requireNonNull(fieldKey);
            if (fieldValue != null && fieldValue.isEmpty()) {
                fieldValue = null;
            }
            this.fieldKey = fieldKey;
            this.fieldValue = fieldValue;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fieldKey == null ? 0 : this.fieldKey.hashCode());
            result = 31 * result + (this.fieldValue == null ? 0 : this.fieldValue.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Grouping other = (Grouping)obj;
            if (this.fieldKey == null ? other.fieldKey != null : !this.fieldKey.equals(other.fieldKey)) {
                return false;
            }
            return !(this.fieldValue == null ? other.fieldValue != null : !this.fieldValue.equals(other.fieldValue));
        }

        public String toString() {
            return EncodingFunctions.encodeUrlParameter((String)this.fieldKey).replace(".", "%2e") + "." + EncodingFunctions.encodeUrlParameter((String)(this.fieldValue == null ? "" : this.fieldValue)).replace(".", "%2e");
        }

        public String getFieldKey() {
            return this.fieldKey;
        }

        public String getFieldValue() {
            return this.fieldValue;
        }
    }
}

