/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.http.ClientMessageException;
import com.inet.usersandgroups.api.FieldValidationException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class FieldEditInformation<VALUE> {
    protected AssetFieldWithDefinition<VALUE> field;

    public FieldEditInformation(AssetFieldWithDefinition<VALUE> field) {
        this.field = field;
    }

    @Nullable
    public String serializeValue(@Nullable AssetView device) {
        Object value = device != null ? device.getValue(this.field) : this.field.getDefaultValue();
        return this.field.asString(value);
    }

    public void updateAssetData(@Nonnull MutableAssetData deviceData, @Nullable String value) {
        VALUE val;
        if (value != null && (val = this.field.valueOf(value)) != null) {
            try {
                deviceData.put(this.field, val);
            }
            catch (FieldValidationException ex) {
                throw new ClientMessageException(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

