/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.handler;

import com.inet.helpdesk.plugins.inventory.client.data.AssetID;
import com.inet.helpdesk.plugins.inventory.client.data.AssetOption;
import com.inet.helpdesk.plugins.inventory.client.data.GetAssetsRequest;
import com.inet.helpdesk.plugins.inventory.client.data.GetAssetsResponse;
import com.inet.helpdesk.plugins.inventory.client.handler.AbstractInventoryHandler;
import com.inet.helpdesk.plugins.inventory.client.handler.LoadTreeGroupingSettings;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.AssetNodeIdentifier;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.TreeGrouping;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.TreeNode;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.settings.ClientTreeSettings;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.id.GUID;
import com.inet.lib.util.EncodingFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class GetAssets
extends AbstractInventoryHandler<GetAssetsRequest, GetAssetsResponse> {
    public String getMethodName() {
        return "inventory.getassets";
    }

    @Override
    public GetAssetsResponse handle(HttpServletRequest req, HttpServletResponse resp, GetAssetsRequest payload) throws IOException {
        if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_READ_WRITE)) {
            throw new AccessDeniedException(InventoryServerPlugin.INVENTORY_READ_WRITE);
        }
        TreeGrouping treeGrouping = LoadTreeGroupingSettings.getTreeGrouping(GUID.valueOf((String)payload.getGroupingKey()));
        ClientTreeSettings.TreeVisibility treeVisibility = ClientTreeSettings.TreeVisibility.valueOf(payload.getTreeVisibility());
        ClientTreeSettings.TreeFilter treeFilter = ClientTreeSettings.TreeFilter.valueOf(payload.getTreeFilter());
        ClientTreeSettings settings = new ClientTreeSettings(payload.getSearchTerm(), treeGrouping, treeVisibility, treeFilter);
        TreeNode rootNode = AssetManager.getInstance().view().searchAssets(settings, payload.getCurrentSize() + payload.getChunkSize());
        AtomicBoolean hasMore = new AtomicBoolean(false);
        List<AssetOption> options = new ArrayList<AssetOption>();
        options.add(new AssetOption(new AssetID(false, ""), "", "", 0, false, false));
        this.convertChildren(rootNode, 0, hasMore, options);
        options = options.subList(payload.getCurrentSize(), Math.min(options.size(), payload.getCurrentSize() + payload.getChunkSize()));
        int totalCount = options.size() + (hasMore.get() ? 1 : 0);
        return new GetAssetsResponse(payload.getRequestNumber(), options, totalCount);
    }

    private void convertChildren(TreeNode rootNode, int level, AtomicBoolean hasMore, List<AssetOption> options) {
        List<TreeNode> children;
        if (rootNode.hasMoreNodes()) {
            hasMore.set(true);
        }
        if ((children = rootNode.getChildren()) != null) {
            for (TreeNode nodeInfo : children) {
                AssetNodeIdentifier deviceId = nodeInfo.getId();
                AssetID id = new AssetID(deviceId.isDevice(), deviceId.toString());
                String displayName = nodeInfo.getDisplayName();
                String iconKey = nodeInfo.getIcon() == null ? null : "field=" + EncodingFunctions.encodeUrlParameter((String)nodeInfo.getIcon().getFieldKey()) + "&value=" + EncodingFunctions.encodeUrlParameter((String)nodeInfo.getIcon().getValue());
                options.add(new AssetOption(id, displayName, iconKey, level, !deviceId.isDevice(), deviceId.isDevice() && nodeInfo.isArchived()));
                this.convertChildren(nodeInfo, level + 1, hasMore, options);
            }
        }
    }
}

