/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.handler;

import com.inet.helpdesk.plugins.inventory.client.InventoryAttachments;
import com.inet.helpdesk.plugins.inventory.client.data.DeleteAttachmentRequest;
import com.inet.helpdesk.plugins.inventory.client.handler.AbstractInventoryHandler;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.HistoryStep;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class DeleteAttachment
extends AbstractInventoryHandler<DeleteAttachmentRequest, Void> {
    public String getMethodName() {
        return "inventory.deleteattachment";
    }

    @Override
    public Void handle(HttpServletRequest req, HttpServletResponse resp, DeleteAttachmentRequest payload) throws IOException {
        if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_READ_WRITE)) {
            throw new AccessDeniedException(InventoryServerPlugin.INVENTORY_READ_WRITE);
        }
        GUID assetId = payload.getAssetId();
        AssetView asset = AssetManager.getInstance().getAsset(assetId);
        if (asset == null) {
            return null;
        }
        String image = asset.getValue(AssetFields.FIELD_IMAGE);
        MutableAssetData data = new MutableAssetData();
        if (payload.getFilename().equals(image)) {
            data.put(AssetFields.FIELD_IMAGE, null);
        }
        List<AssetManager.AdditionalTask> extData = Collections.singletonList((updatedAsset, historyAdder) -> {
            InventoryAttachments.deleteAttachment(payload.getOwnerId(), payload.getFilename());
            long currentTimeMillis = System.currentTimeMillis();
            GUID currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID();
            historyAdder.accept(new HistoryStep(updatedAsset.getIntID(), currentTimeMillis, currentUserAccountID, AssetManager.MSG.getMsg("attachment.history.delete", new Object[]{payload.getFilename()})));
        });
        AssetManager.getInstance().updateAsset(assetId, data, extData);
        return null;
    }
}

