/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.group;

import com.inet.field.SelectOption;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithFieldGroup;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_Select;
import com.inet.helpdesk.plugins.inventory.server.webapi.InventoryWebAPIExtension;
import com.inet.helpdesk.plugins.inventory.server.webapi.group.InventoryFieldWithGroupDetailsHandler;
import com.inet.http.ClientMessageException;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="Inventory", description="Operations for managing inventory assets")
public class InventoryFieldWithGroupHandler
extends RequestHandlerBase<Void, Map<String, String>> {
    private AssetFieldDefinition field;

    public InventoryFieldWithGroupHandler(AssetFieldDefinition field) {
        super(new String[]{field.getFieldKey()});
        if (!(field instanceof AssetFieldWithFieldGroup)) {
            throw new IllegalArgumentException("Types do not match. Programming error");
        }
        this.field = field;
        this.setGenericRequestHandler((RequestHandler)new InventoryFieldWithGroupDetailsHandler(field));
    }

    public String getHelpPageKey() {
        return "webapi.inventory.group." + this.field.getFieldKey();
    }

    @Operation(summary="Get field group options", description="Retrieves available selection options for a field that supports field groups (e.g., SLA, license, vendor)", responses={@ApiResponse(responseCode="200", description="Map of option values to their display labels retrieved successfully"), @ApiResponse(responseCode="400", description="Field does not support field groups"), @ApiResponse(responseCode="401", description="User not authorized to access field groups")})
    public Map<String, String> handle(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nullable Void inputObject, @Nonnull List<String> pathTokens, boolean previewModeEnabled) throws IOException {
        if (this.field instanceof AssetField_Select) {
            AssetField_Select select = (AssetField_Select)this.field;
            List options = select.getSelectOptions(true);
            return options.stream().filter(o -> o.getValue() != null).collect(Collectors.toMap(SelectOption::getValue, SelectOption::getLabel));
        }
        throw new ClientMessageException(InventoryWebAPIExtension.MSG.getMsg("inventory.group.field.notFound", new Object[]{this.field.getFieldKey()}));
    }
}

