/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.field.SelectOption;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithFieldGroup;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@Schema(description="Detailed information about a field group selection option and its associated fields")
public class InventoryFieldWithGroupDetailResponse {
    @Schema(description="The unique identifier of the field group", required=true)
    private String id;
    @Schema(description="The display name of the field group")
    @JsonExcludeNull
    private String name;
    @Schema(description="The icon identifier or URL for the field group")
    @JsonExcludeNull
    private String icon;
    @Schema(description="Whether this field group is marked as deleted")
    @JsonExcludeNull
    private Boolean deleted;
    @Schema(description="List of detail fields associated with this field group")
    private List<Details> detailFields = new ArrayList<Details>();

    private InventoryFieldWithGroupDetailResponse() {
    }

    public static InventoryFieldWithGroupDetailResponse from(String tokenObject, @Nullable SelectOption fieldSelection, @Nonnull List<AssetFieldWithFieldGroup.AdditionalDetailField> additionalFields) {
        InventoryFieldWithGroupDetailResponse result = new InventoryFieldWithGroupDetailResponse();
        if (fieldSelection != null) {
            result.name = fieldSelection.getLabel();
            result.icon = fieldSelection.getIcon();
            result.deleted = fieldSelection.isDisabled();
        }
        result.detailFields = additionalFields.stream().map(f -> Details.from(f)).collect(Collectors.toList());
        result.id = tokenObject;
        return result;
    }

    @JsonData
    @Schema(description="Information about a single detail field within a field group")
    private static class Details {
        @Schema(description="The unique key of the detail field", required=true)
        private String key;
        @Schema(description="The display label for the detail field")
        @JsonExcludeNull
        private String label;
        @Schema(description="The current value of the detail field", required=true)
        private String value;

        private Details() {
        }

        public static Details from(AssetFieldWithFieldGroup.AdditionalDetailField field) {
            Details details = new Details();
            details.key = field.getKey();
            details.label = field.getLabel();
            details.value = field.getDisplayValue((String)null);
            return details;
        }
    }
}

