/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.field.Field;
import com.inet.field.SelectOption;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.AssetFieldUser;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithFieldGroup;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_Select;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.usersandgroups.api.user.UserManager;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonData
@Schema(description="Definition and metadata for an inventory asset field")
public class InventoryAssetField {
    @Schema(description="The unique key identifying the field", required=true)
    private String key;
    @Schema(description="The display label for the field", required=true)
    private String label;
    @Schema(description="A detailed description of the field's purpose")
    private String description;
    @Schema(description="The display priority of the field", defaultValue="0")
    private int priority;
    @Schema(description="The data type of the field", required=true)
    private String type;
    @Schema(description="Additional properties specific to this field type")
    @JsonExcludeNull
    private Map<String, String> properties;
    @Schema(description="Additional fields available when this field is part of a field group")
    @JsonExcludeNull
    private Map<String, String> additionalFields;
    @Schema(description="Available options for selection fields, mapping values to display labels")
    @JsonExcludeNull
    private Map<String, String> selectionOptions;

    private InventoryAssetField() {
    }

    public static InventoryAssetField from(AssetFieldDefinition af) {
        InventoryAssetField field = new InventoryAssetField();
        if (af instanceof AssetFieldWithFieldGroup) {
            String jsonValue;
            List<AssetFieldWithFieldGroup.AdditionalDetailField> fields;
            SelectOption option = null;
            AssetFieldWithFieldGroup withGroup = (AssetFieldWithFieldGroup)((Object)af);
            if (af instanceof AssetField_Select) {
                option = InventoryAssetField.getSelectOptionsfor(withGroup);
            } else if (af instanceof AssetFieldUser) {
                option = InventoryAssetField.getUserOptionsfor(withGroup);
            }
            if (option != null && (fields = withGroup.getAdditionalFields(jsonValue = new Json().toJson((Object)option))) != null) {
                field.additionalFields = fields.stream().collect(Collectors.toMap(Field::getKey, AssetFieldWithFieldGroup.AdditionalDetailField::getLabel));
            }
        }
        if (af instanceof AssetField_Select) {
            AssetField_Select af_select = (AssetField_Select)af;
            af_select.updateSettings();
            field.selectionOptions = af_select.getSelectOptions(true).stream().filter(f -> f.getValue() != null).collect(Collectors.toMap(SelectOption::getValue, SelectOption::getLabel));
        }
        field.type = af.getDisplayType().toString();
        field.key = af.getFieldKey();
        field.description = af.getDescription();
        field.label = af.getLabel();
        field.properties = af.getAdditionalProperties();
        if (field.properties.isEmpty()) {
            field.properties = null;
        }
        field.priority = af.getPriority();
        return field;
    }

    @Nullable
    private static SelectOption getUserOptionsfor(AssetFieldWithFieldGroup af) {
        GUID accountID = UserManager.getInstance().getCurrentUserAccountID();
        if (accountID == null) {
            return null;
        }
        String userId = accountID.toString();
        return new SelectOption(userId, userId);
    }

    @Nullable
    private static SelectOption getSelectOptionsfor(AssetFieldWithFieldGroup af) {
        AssetField_Select af_select = (AssetField_Select)((Object)af);
        return af_select.getSelectOptions(true).stream().filter(f -> f.getValue() != null).findAny().orElse(null);
    }
}

