/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.ticket;

import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.taskplanner.server.placeholder.PlaceholderProvider;
import com.inet.id.GUID;
import com.inet.plugin.DynamicExtensionManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class InventoryPlaceholderProvider
implements PlaceholderProvider {
    String PROPERTY_PLACEHOLDER_ACTION_PREFIX = "action.asset.";
    String PROPERTY_PLACEHOLDER_ACTION_ASSET_ID = this.PROPERTY_PLACEHOLDER_ACTION_PREFIX + "id";
    String PROPERTY_PLACEHOLDER_ACTION_ASSET_NAME = this.PROPERTY_PLACEHOLDER_ACTION_PREFIX + "name";

    @Nonnull
    public List<String> getAdditionalPlaceholderKeys() {
        ArrayList<String> keys = new ArrayList<String>(){
            {
                this.add(InventoryPlaceholderProvider.this.PROPERTY_PLACEHOLDER_ACTION_ASSET_ID);
                this.add(InventoryPlaceholderProvider.this.PROPERTY_PLACEHOLDER_ACTION_ASSET_NAME);
            }
        };
        this.getDeviceFieldDefinitions().stream().map(d -> this.PROPERTY_PLACEHOLDER_ACTION_PREFIX + d.getFieldKey()).forEach(keys::add);
        return keys;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    List<@Nonnull AssetFieldDefinition> getDeviceFieldDefinitions() {
        @Nonnull List deviceFields = DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class);
        deviceFields.sort((a, b) -> {
            int compare = Integer.compare(a.getPriority(), b.getPriority());
            if (compare == 0) {
                compare = String.CASE_INSENSITIVE_ORDER.compare(a.getLabel(), b.getLabel());
            }
            return compare;
        });
        return deviceFields;
    }

    @Nonnull
    public Map<String, String> getPlaceholderValuesFor(ActionVO action, ReaStepVO reaStepData, ReaStepTextVO reaStepText) {
        GUID value;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(this.PROPERTY_PLACEHOLDER_ACTION_ASSET_ID, "");
        props.put(this.PROPERTY_PLACEHOLDER_ACTION_ASSET_NAME, "");
        if (reaStepData != null && (value = (GUID)reaStepData.getValue((ReaStepField)AssetFields.FIELD_INVENTORY_ASSETID)) != null) {
            props.put(this.PROPERTY_PLACEHOLDER_ACTION_ASSET_ID, value.toString());
            AssetView asset = this.getAssetManager().getAsset(value);
            if (asset != null) {
                props.put(this.PROPERTY_PLACEHOLDER_ACTION_ASSET_NAME, asset.getName());
                this.getDeviceFieldDefinitions().stream().forEach(d -> props.put(this.PROPERTY_PLACEHOLDER_ACTION_PREFIX + d.getFieldKey(), d.getDisplayValue(asset)));
            }
        }
        return props;
    }

    protected AssetManager getAssetManager() {
        return AssetManager.getInstance();
    }

    @Nonnull
    public Map<String, String> getPlaceholderValuesFor(TicketVO ticket) {
        return new HashMap<String, String>();
    }
}

