/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.reporting;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ImagesConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.inventory.client.InventoryAttachments;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.formula.UserDefinedFunction;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;

public class InventoryReportingFunctions
implements UserDefinedFunction {
    private static final ConfigValue<String> SERVER_URL = new ConfigValue<String>(ConfigKey.SERVER_URL){

        protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
            if (StringFunctions.isEmpty((String)strValue)) {
                strValue = ConfigKey.SERVER_URL.getDefault();
            }
            if (strValue != null && !((String)strValue).endsWith("/")) {
                strValue = (String)strValue + "/";
            }
            super.setValue((String)strValue);
        }
    };

    public static String getAssetFieldLabel(String column) {
        if (column == null) {
            return "";
        }
        AssetFieldDefinition afd = DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class).stream().filter(f -> f.getFieldKey().equals(column)).findFirst().orElse(null);
        return afd != null ? afd.getLabel() : "";
    }

    public static String getAssetName(String id) {
        AssetView asset = AssetManager.getInstance().getAsset(new GUID(id));
        if (asset == null) {
            return null;
        }
        return asset.getValue(AssetFields.FIELD_NAME);
    }

    public static byte[] getTypeImage(int category, Integer type, int size) {
        ImagesConnector imagesConnector;
        URL stateImage;
        if (type != null && (stateImage = (imagesConnector = (ImagesConnector)ServerPluginManager.getInstance().getSingleInstance(ImagesConnector.class)).getDataImage(category, type.toString(), size)) != null) {
            try {
                return IOFunctions.getFileBuffer((URL)stateImage);
            }
            catch (IOException e) {
                HDLogger.error((Object)e);
            }
        }
        return InventoryReportingFunctions.createEmptyImage();
    }

    public static byte[] getAssetTypeImage(Integer type, int size) {
        return InventoryReportingFunctions.getTypeImage(14, type, size);
    }

    public static byte[] getLicenseTypeImage(Integer type, int size) {
        return InventoryReportingFunctions.getTypeImage(15, type, size);
    }

    public static byte[] getVendorTypeImage(Integer type, int size) {
        return InventoryReportingFunctions.getTypeImage(16, type, size);
    }

    public static byte[] getSLATypeImage(Integer type, int size) {
        return InventoryReportingFunctions.getTypeImage(17, type, size);
    }

    public static byte[] getAssetImage(String id) throws SQLException {
        AssetView asset = AssetManager.getInstance().getAsset(new GUID(id));
        if (asset == null) {
            return null;
        }
        String value = asset.getValue(AssetFields.FIELD_IMAGE);
        AttachmentService s = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
        List<Integer> assetIds = Arrays.asList(asset.getIntID());
        Map fullAttachmentDataFor = s.getFullAttachmentDataFor(AttachmentOwnerType.DeviceAttachment, assetIds);
        for (AttachmentRow row : fullAttachmentDataFor.keySet()) {
            String fileName = row.getFileName();
            if (!fileName.equals(value)) continue;
            String filePath = ((AttachmentFileRow)fullAttachmentDataFor.get(row)).getFilePath();
            PersistenceEntry attachmentFile = AppDataLocation.getAttachmentFile((String)filePath);
            return attachmentFile.getBytes();
        }
        return null;
    }

    public static byte[] getAssetTypeImage(Integer type) {
        return InventoryReportingFunctions.getAssetTypeImage(type, 32);
    }

    private static byte[] createEmptyImage() {
        BufferedImage image = new BufferedImage(16, 16, 2);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            HDLogger.error((Object)ioe);
            return new byte[0];
        }
    }

    public static int getAssetAttachmentCount(String id) throws ServerDataException {
        return InventoryAttachments.getAttachments(new GUID(id)).size();
    }

    public static String getDirectLink(String id) {
        if (StringFunctions.isEmpty((String)id)) {
            return null;
        }
        return (String)SERVER_URL.get() + "inventory/asset/" + id;
    }

    public static Integer getUserId(String assetUUID) {
        AssetView asset = AssetManager.getInstance().getAsset(new GUID(assetUUID));
        GUID value = asset.getValue(AssetFields.FIELD_OWNER);
        if (value == null) {
            return null;
        }
        int userID = HDUsersAndGroups.getUserID((GUID)value);
        if (userID == -1) {
            return null;
        }
        return userID;
    }
}

