/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.reporting;

import com.inet.annotations.InternalApi;
import com.inet.cache.MemoryStoreMap;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithFieldGroup;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithIcon;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.id.GUID;
import com.inet.lib.util.IOFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.report.Datasource;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.SimpleResultSet;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import java.io.InputStream;
import java.net.URL;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class InventoryDataSourceConfiguration
extends BaseDataFactory {
    public static final String TABLE_ASSETS = "Assets";
    private static final MemoryStoreMap<String, byte[]> ICON_CACHE = new MemoryStoreMap(30, true);

    public boolean getReportDataPerInstance() {
        return true;
    }

    @Nonnull
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Hardcoded for inventory reports")
    public TableData getTableSourceData(@Nonnull TableSource ts) throws ReportException {
        Set searchResult;
        ArrayList columns = new ArrayList();
        List<ColumnInfo> cols = this.getColumns(ts);
        cols.stream().filter(c -> c.getColumnType() == 3).forEach(c -> columns.add(c.getName()));
        Object gerUUID = null;
        List prompts = ts.getInputParameters();
        if (prompts.size() > 0) {
            PromptField field = (PromptField)prompts.get(0);
            gerUUID = field.getValue();
        }
        if (gerUUID != null) {
            searchResult = Collections.singleton(GUID.valueOf((String)gerUUID.toString()));
        } else {
            SearchCommand command = new SearchCommand(new SearchExpression[]{new SearchCondition(AssetFields.FIELD_NAME.getKey(), SearchCondition.SearchTermOperator.StartsWith, (Object)"")});
            searchResult = this.getSearchEngine().simpleSearch(command);
        }
        SimpleResultSet rs = new SimpleResultSet(columns.toArray(new String[columns.size()])){
            private final Iterator<GUID> ids;
            private final Map<Integer, List<AssetFieldDefinition>> fieldsPerType;
            {
                super(arg0);
                this.ids = searchResult.iterator();
                this.fieldsPerType = InventoryDataSourceConfiguration.this.getDeviceFieldsByTypeId();
            }

            @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Only reading saved icon files")
            public boolean next() throws SQLException {
                if (this.getRowCount() > 0) {
                    return super.next();
                }
                while (this.ids.hasNext()) {
                    GUID id = this.ids.next();
                    AssetView asset = InventoryDataSourceConfiguration.this.getAssetViewFor(id);
                    GUID ownerID = asset.getValue(AssetFields.FIELD_OWNER);
                    GUID assetID = asset.getId();
                    Integer type = asset.getValue(AssetFields.FIELD_TYPE);
                    List<AssetFieldDefinition> typeSpesificFields = this.fieldsPerType.get(type);
                    if (typeSpesificFields == null || typeSpesificFields.size() <= 0) continue;
                    for (AssetFieldDefinition fieldDefinition : typeSpesificFields) {
                        String iconValue;
                        Object value;
                        Object[] rowData = new Object[7];
                        rowData[0] = assetID.toString();
                        rowData[1] = ownerID != null ? ownerID.toString() : null;
                        rowData[2] = fieldDefinition.getLabel();
                        rowData[3] = fieldDefinition.getFieldKey();
                        rowData[4] = value = InventoryDataSourceConfiguration.this.handleValueTyp(fieldDefinition, asset);
                        if (fieldDefinition instanceof AssetFieldWithIcon && (iconValue = ((AssetFieldWithIcon)((Object)fieldDefinition)).getIconValue(asset, (AssetField)((Object)fieldDefinition))) != null) {
                            URL icon;
                            String cacheKey = fieldDefinition.getFieldKey() + iconValue;
                            byte[] bytes = (byte[])ICON_CACHE.get((Object)cacheKey);
                            if (bytes == null && (icon = fieldDefinition.getIcon(iconValue, 32)) != null) {
                                try (InputStream in = icon.openStream();){
                                    bytes = IOFunctions.readBytes((InputStream)in);
                                    ICON_CACHE.put((Object)cacheKey, (Object)bytes);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            rowData[5] = bytes;
                        }
                        rowData[6] = Boolean.FALSE;
                        if (fieldDefinition instanceof AssetFieldWithFieldGroup) {
                            rowData[6] = Boolean.TRUE;
                        }
                        this.getAllRows().add(rowData);
                    }
                    return super.next();
                }
                return super.next();
            }
        };
        return new TableData((ResultSet)rs);
    }

    protected AssetView getAssetViewFor(GUID id) {
        return AssetManager.getInstance().getAsset(id);
    }

    protected IndexSearchEngine<GUID> getSearchEngine() {
        return AssetManager.getInstance().getSearchEngine();
    }

    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(@Nonnull Datasource ds, String catalog) throws ReportException {
        return Collections.singletonMap(TABLE_ASSETS, new TableSourceInfo(null, null, TABLE_ASSETS, 20));
    }

    @Nonnull
    public List<ColumnInfo> getColumns(@Nonnull TableSource ts) throws ReportException {
        ArrayList<ColumnInfo> cols = new ArrayList<ColumnInfo>();
        if (ts.getDatabaseIdentifier().equals(TABLE_ASSETS)) {
            cols.add(new ColumnInfo("GerUUID", 11));
            cols.add(new ColumnInfo("UserUUID", 11));
            cols.add(new ColumnInfo("Label", 11));
            cols.add(new ColumnInfo("FieldKey", 11));
            cols.add(new ColumnInfo("Value", 11));
            cols.add(new ColumnInfo("Icon", 14));
            cols.add(new ColumnInfo("IsFieldGroup", 8));
            cols.add(new ColumnInfo("GerUUID", 11, 1, 12, 0));
        }
        return cols;
    }

    protected List<AssetFieldDefinition> getAssetFieldDefinitions() {
        List assetFields = DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class);
        assetFields.sort((a, b) -> {
            if ("parent".equalsIgnoreCase(a.getFieldKey())) {
                return -1;
            }
            if ("parent".equalsIgnoreCase(b.getFieldKey())) {
                return 1;
            }
            if (a instanceof AssetFieldWithFieldGroup && !(b instanceof AssetFieldWithFieldGroup)) {
                return 1;
            }
            if (!(a instanceof AssetFieldWithFieldGroup) && b instanceof AssetFieldWithFieldGroup) {
                return -1;
            }
            int compare = Integer.compare(a.getPriority(), b.getPriority());
            if (compare == 0) {
                compare = String.CASE_INSENSITIVE_ORDER.compare(a.getLabel(), b.getLabel());
            }
            return compare;
        });
        ArrayList<String> exclude = new ArrayList<String>();
        exclude.add("name");
        return assetFields.stream().filter(a -> !exclude.contains(a.getFieldKey())).collect(Collectors.toList());
    }

    protected Map<Integer, List<AssetFieldDefinition>> getDeviceFieldsByTypeId() {
        HashMap<Integer, List<AssetFieldDefinition>> deviceFieldsMapping = new HashMap<Integer, List<AssetFieldDefinition>>();
        List all = AssetTypeManager.getInstance().getAll(true);
        all.stream().forEach(e -> deviceFieldsMapping.put(e.getId(), new ArrayList()));
        List<AssetFieldDefinition> deviceFields = this.getAssetFieldDefinitions();
        for (AssetFieldDefinition fieldDefinition : deviceFields) {
            deviceFieldsMapping.entrySet().stream().forEach(e -> {
                if (fieldDefinition.isVisibleInType((Integer)e.getKey())) {
                    ((List)e.getValue()).add(fieldDefinition);
                }
            });
        }
        return deviceFieldsMapping;
    }

    private Object handleValueTyp(AssetFieldDefinition afd, AssetView asset) {
        FieldSettingsType type = afd.getDisplayType();
        if (type == FieldSettingsType.TYPE_DATE || type == FieldSettingsType.TYPE_DATE_TIME) {
            Long value = (Long)asset.getValue((AssetFieldWithDefinition)afd);
            return value != null ? DateFormat.getDateInstance(3).format(new Date(value)) : null;
        }
        if (type == FieldSettingsType.TYPE_CURRENCY) {
            Object value = asset.getValue((AssetFieldWithDefinition)afd);
            if (value == null) {
                return null;
            }
            return NumberFormat.getCurrencyInstance().format(value);
        }
        if (type == FieldSettingsType.TYPE_NUMBER) {
            Object value = asset.getValue((AssetFieldWithDefinition)afd);
            if (value == null) {
                return null;
            }
            return NumberFormat.getIntegerInstance().format(value);
        }
        return afd.getDisplayValue(asset);
    }
}

