/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.config;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.BooleanConfigProperty;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.model.TableConfigProperty;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.fieldsettings.api.AbstractFieldSettingsManager;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.structure.GenericFieldSettingsProperty;
import com.inet.helpdesk.core.ticketfieldsettings.SqlQuerySelectValueProvider;
import com.inet.helpdesk.plugins.inventory.server.api.AssetFieldSettingsManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.config.InventoryGenericFieldsStructureProvider;
import com.inet.helpdesk.plugins.inventory.server.config.generics.TypeListConfigProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonData
public class AssetFieldSettingsProperty
extends GenericFieldSettingsProperty {
    public static final String PROP_MANDATORY = "prop_mandatory";
    public static final String PROP_DEFAULT_REPLACES_NULL = "prop_default_replaces_null";
    public static final String PROP_VISIBLE_IF = "prop_visible_if";

    public AssetFieldSettingsProperty(String key, ConfigStructureSettings settings, AbstractFieldSettingsManager<?, ?> manager) {
        super(key, settings, manager);
        this.setDuplicatePossible(true);
    }

    protected Map<String, String> createRowPropertiesFor(GenericFieldSetting setting, AbstractFieldSettingsManager<?, ?> manager) {
        Map rowProps = super.createRowPropertiesFor(setting, manager);
        if (AssetFields.isOpenField(setting.getKey())) {
            rowProps.put("disableDeleteButton", "true");
        }
        return rowProps;
    }

    protected ConfigRowAction[] createRowActions(ConfigStructureSettings settings, AbstractFieldSettingsManager<?, ?> manager) {
        ConfigRowAction[] rowActions = super.createRowActions(settings, manager);
        ArrayList conditions = rowActions[0].getConditions();
        ConditionGenerator g = new ConditionGenerator();
        ArrayList condNOTAlwaysAllowedFields = new ArrayList();
        TypeListConfigProperty.ENABLED_FIELDS_ALWAYS_ALLOWED.forEach(field -> {
            ConfigCondition c = g.createCondition().property("fieldsettingsKey").equals().value(field);
            condNOTAlwaysAllowedFields.add(g.createCondition().not(c));
        });
        ConfigCondition[] array = condNOTAlwaysAllowedFields.toArray(new ConfigCondition[condNOTAlwaysAllowedFields.size()]);
        conditions.add(g.enableActionFor(g.createCondition().and(array), PROP_DEFAULT_REPLACES_NULL));
        conditions.add(g.enableActionFor(g.createCondition().and(array), PROP_MANDATORY));
        conditions.add(g.enableActionFor(g.createCondition().and(array), PROP_VISIBLE_IF));
        conditions.add(g.visibleActionFor(g.createCondition().not(g.createCondition().property("type").equals().value((Object)FieldSettingsType.TYPE_LINK.toString())), PROP_MANDATORY));
        ArrayList isATypeWithDefaultvalue = new ArrayList();
        AssetFieldSettingsManager.getInstance().getSupportedTypesForCustomFields().forEach(t -> {
            if (t.getDefaultValuePropertyKey() != null) {
                isATypeWithDefaultvalue.add(g.createCondition().property("type").equals().value((Object)t.toString()));
            }
        });
        ConfigCondition condHasAnyDefaultvalue = g.createCondition().or(isATypeWithDefaultvalue.toArray(new ConfigCondition[isATypeWithDefaultvalue.size()]));
        conditions.add(g.visibleActionFor(condHasAnyDefaultvalue, PROP_DEFAULT_REPLACES_NULL));
        List propertyList = (List)rowActions[0].getProperties().get("field.new.group");
        SqlQuerySelectValueProvider.structure_addPropertiesAndConditionsInRowAction((List)conditions, (List)propertyList);
        propertyList.add(new BooleanConfigProperty(33, PROP_DEFAULT_REPLACES_NULL, "Boolean", InventoryGenericFieldsStructureProvider.MSG.getMsg("fields.row.defaultReplacesNull", new Object[0]), null, null, (Object)"false"));
        propertyList.add(AssetFieldSettingsProperty.propWith((String)"Boolean", (String)InventoryGenericFieldsStructureProvider.MSG.getMsg("fields.row.mandatory", new Object[0]), (String)PROP_MANDATORY, (String)"false"));
        List options = AssetTypeManager.getInstance().getAll(true).stream().map(type -> new LocalizedKey(String.valueOf(type.getId()), type.getDisplayValue())).collect(Collectors.toList());
        options.add(0, new LocalizedKey(String.valueOf(-2), InventoryGenericFieldsStructureProvider.MSG.getMsg("fields.rows.visibleIf.always", new Object[0])));
        ConfigAction[] addFieldAction = new ConfigAction[]{new ConfigAction(InventoryGenericFieldsStructureProvider.MSG.getMsg("fields.row.visible.add", new Object[0]))};
        String key = PROP_VISIBLE_IF;
        List rows = Collections.emptyList();
        ConfigProperty[] columns = new ConfigProperty[]{new SelectConfigProperty(0, "Field", "SimpleText", InventoryGenericFieldsStructureProvider.MSG.getMsg("fields.rows.visible.tableHead", new Object[0]), null, null, options)};
        String label = InventoryGenericFieldsStructureProvider.MSG.getMsg("fields.row.visibleIf", new Object[0]);
        int[] columnSizes = new int[]{100};
        TableConfigProperty showFieldifTypeIsProperty = new TableConfigProperty(0, key, "SimpleTextReloadSelectInputs", label, "", rows, columns, columnSizes, addFieldAction, null);
        showFieldifTypeIsProperty.setEmptyLabel(InventoryGenericFieldsStructureProvider.MSG.getMsg("fields.rows.visible.emptyHint", new Object[0]));
        showFieldifTypeIsProperty.setSortable(true);
        propertyList.add(showFieldifTypeIsProperty);
        return rowActions;
    }
}

