/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_String;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;

public interface AssetFieldWithFieldGroup {
    @Nullable
    public LocalizedKey getFieldGroup();

    @Nullable
    public List<AdditionalDetailField> getAdditionalFields(String var1);

    public static class AdditionalDetailField
    extends AssetField_String {
        private String label;
        private String value;
        private String hyperlink;

        public AdditionalDetailField(String key, int priority, boolean multiline, String label, String value) {
            super(key, "", priority, multiline ? FieldSettingsType.TYPE_MULTILINE_TEXT : FieldSettingsType.TYPE_TEXT, -1);
            this.label = label;
            this.value = value;
        }

        public AdditionalDetailField(String key, int priority, String label, String title, String hyperlink) {
            super(key, "", priority, FieldSettingsType.TYPE_LINK, -1);
            this.label = label;
            this.value = title;
            this.hyperlink = hyperlink;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public String getDisplayValue(AssetView device) {
            return this.value;
        }

        @Override
        public String getDisplayValue(String value) {
            return this.value;
        }

        public String getHyperlink() {
            return this.hyperlink;
        }

        public static String formatAsDate(Long timestamp) {
            if (timestamp == null) {
                return null;
            }
            DateFormat dateTimeInstance = DateFormat.getDateInstance(2, ClientLocale.getThreadLocale());
            dateTimeInstance.setTimeZone(ClientTimezone.getTimeZone());
            return dateTimeInstance.format(new Date(timestamp));
        }
    }
}

