/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts;

import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.api.model.LinkField;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.FieldEditInformation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssetFieldDefinitionLink
implements AssetFieldDefinition {
    private GenericFieldSetting settings;
    private List<Integer> types;

    public AssetFieldDefinitionLink(GenericFieldSetting settings) {
        this.settings = settings;
    }

    public String getFieldKey() {
        return this.settings.getKey();
    }

    public void setSortPrio(int prio) {
    }

    public int getPriority() {
        return this.settings.getSortPriority();
    }

    @Override
    public FieldSettingsType getDisplayType() {
        return FieldSettingsType.TYPE_LINK;
    }

    @Override
    @Nullable
    public String getDisplayValue(AssetView device) {
        String title = LinkField.buildTitle((GenericFieldSetting)this.settings, this.getFieldResolver(device));
        return title;
    }

    private Function<String, String> getFieldResolver(AssetView device) {
        return key -> {
            if (device == null) {
                return null;
            }
            AssetField fieldByKey = AssetFields.getFieldFor(key);
            if (fieldByKey == null) {
                if (Objects.equals("assetid", key)) {
                    return device.getId().toString();
                }
                return null;
            }
            return fieldByKey.getFieldType().asString(device.getValue(fieldByKey));
        };
    }

    @Override
    public FieldEditInformation<?> getEditInformation() {
        return new FieldEditInformation<String>(null){

            @Override
            public String serializeValue(AssetView device) {
                return AssetFieldDefinitionLink.this.getDisplayValue(device);
            }
        };
    }

    @Nullable
    public String getHyperlink(AssetView device) {
        return LinkField.buildLink((GenericFieldSetting)this.settings, this.getFieldResolver(device));
    }

    @Override
    @Nonnull
    public Map<String, String> getAdditionalProperties() {
        return Collections.emptyMap();
    }

    @Override
    public List<Integer> getVisibleIfTypeIs() {
        return this.types;
    }

    @Override
    public void setVisibleIfTypeIs(List<Integer> types) {
        this.types = types;
    }

    public String toString() {
        return this.getFieldKey();
    }
}

