/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model.field;

import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.FieldEditInformation;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.usersandgroups.api.FieldValidationException;

public class AssetField_Parent
extends AssetFieldWithDefinition<GUID> {
    public AssetField_Parent(String fieldKey, int sortPrio) {
        super(fieldKey, null, sortPrio, FieldSettingsType.TYPE_TEXT, FieldTypeFactory.auto());
    }

    @Override
    public void validateRealValue(GUID parentID) throws FieldValidationException {
        if (parentID != null && AssetManager.getInstance().getAsset(parentID) == null) {
            throw new IllegalArgumentException("No device exists for given parent id: " + String.valueOf(parentID));
        }
    }

    @Override
    public String getDisplayValue(GUID value) {
        try {
            AssetView device = AssetManager.getInstance().getAsset(value);
            if (device == null) {
                return AssetManager.MSG.getMsg("device.field.deletedAsset", new Object[0]);
            }
            return device.getName();
        }
        catch (AccessDeniedException ex) {
            return AssetManager.MSG.getMsg("device.field.unaccessibleAsset", new Object[0]);
        }
    }

    @Override
    public GUID valueOf(String stringRepresentation) {
        return GUID.valueOf((String)stringRepresentation);
    }

    @Override
    public FieldEditInformation<GUID> getEditInformation() {
        return null;
    }

    @Override
    public GUID getValueFromIndexedValue(Object indexedValue) {
        if (indexedValue == null) {
            return null;
        }
        return GUID.valueOf((String)((String)indexedValue));
    }
}

