/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.handler;

import com.inet.helpdesk.plugins.inventory.client.data.UndeleteAssetRequest;
import com.inet.helpdesk.plugins.inventory.client.handler.AbstractInventoryHandler;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class UndeleteAssets
extends AbstractInventoryHandler<UndeleteAssetRequest, Void> {
    public String getMethodName() {
        return "inventory.undeleteasset";
    }

    @Override
    public Void handle(HttpServletRequest req, HttpServletResponse resp, UndeleteAssetRequest payload) throws IOException {
        if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_READ_WRITE)) {
            throw new AccessDeniedException(InventoryServerPlugin.INVENTORY_READ_WRITE);
        }
        for (String id : payload.getIds()) {
            try {
                GUID guid = GUID.valueOf((String)id);
                if (guid == null) continue;
                AssetManager.getInstance().unarchiveAsset(guid, payload.isSubAssets());
            }
            catch (AccessDeniedException | IllegalArgumentException e) {
                throw new ClientMessageException(e.getMessage());
            }
        }
        return null;
    }
}

