/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.handler;

import com.inet.config.ConfigurationManager;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.plugins.inventory.client.data.InventoryTreeGroupEntry;
import com.inet.helpdesk.plugins.inventory.client.data.InventoryTreeGroupEntryDescription;
import com.inet.helpdesk.plugins.inventory.client.data.SaveTreeGroupingSettingsRequest;
import com.inet.helpdesk.plugins.inventory.client.handler.AbstractInventoryHandler;
import com.inet.helpdesk.plugins.inventory.client.handler.LoadTreeGroupingSettings;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.lib.json.Json;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SaveTreeGroupingSettings
extends AbstractInventoryHandler<SaveTreeGroupingSettingsRequest, Void> {
    public String getMethodName() {
        return "inventory.savetreegroupingsettings";
    }

    @Override
    public Void handle(HttpServletRequest req, HttpServletResponse resp, SaveTreeGroupingSettingsRequest payload) throws IOException {
        if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_READ_WRITE)) {
            throw new AccessDeniedException(InventoryServerPlugin.INVENTORY_READ_WRITE);
        }
        ArrayList<InventoryTreeGroupEntryDescription> groupingDescription = payload.getGroupingDescription();
        ArrayList<InventoryTreeGroupEntry> groupingConfig = new ArrayList<InventoryTreeGroupEntry>();
        for (InventoryTreeGroupEntryDescription inventoryTreeGroupEntryDescription : groupingDescription) {
            InventoryTreeGroupEntry inventoryTreeGroupEntry = new InventoryTreeGroupEntry(inventoryTreeGroupEntryDescription.getKey(), inventoryTreeGroupEntryDescription.getName());
            List<LocalizedKey> entries = inventoryTreeGroupEntryDescription.getEntries();
            inventoryTreeGroupEntry.setGroupingKeys(entries.stream().map(e -> e.getKey()).collect(Collectors.toList()));
            groupingConfig.add(inventoryTreeGroupEntry);
        }
        ConfigurationManager.getInstance().getCurrent().put(InventoryServerPlugin.CONFIGKEY_GROUPING, groupingConfig.size() == 0 ? null : new Json().toJson(groupingConfig));
        List groupings = ((List)LoadTreeGroupingSettings.GROUPING_LIST.get()).stream().sorted((a, b) -> a.getName().compareToIgnoreCase(b.getName())).map(g -> new LocalizedKey(g.getKey().toString(), g.getName())).collect(Collectors.toList());
        AssetManager.getInstance().view().getTreeClients().keySet().forEach(clientId -> WebSocketEventHandler.getInstance().sendEvent(clientId, () -> new WebSocketEventData("inventory.tree.groupings", (Object)groupings)));
        return null;
    }
}

