/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.handler;

import com.inet.field.SelectOption;
import com.inet.helpdesk.plugins.inventory.client.data.PrepareNewAssetRequest;
import com.inet.helpdesk.plugins.inventory.client.data.PrepareNewAssetResponse;
import com.inet.helpdesk.plugins.inventory.client.handler.AbstractInventoryHandler;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.FieldEditInformation;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.AssetNodeIdentifier;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PrepareNewAsset
extends AbstractInventoryHandler<PrepareNewAssetRequest, PrepareNewAssetResponse> {
    public String getMethodName() {
        return "inventory.preparenewasset";
    }

    @Override
    public PrepareNewAssetResponse handle(HttpServletRequest req, HttpServletResponse resp, PrepareNewAssetRequest payload) throws IOException {
        String parentKey;
        AssetNodeIdentifier parentIdentifier;
        List<String> parentIds = payload.getParentIds();
        HashMap<String, String> values = new HashMap<String, String>();
        HashMap<String, AssetView.ValueSource> inheritedFields = new HashMap<String, AssetView.ValueSource>();
        GUID currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID();
        GUID parentId = null;
        if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_READ_WRITE)) {
            throw new AccessDeniedException(InventoryServerPlugin.INVENTORY_READ_WRITE);
        }
        for (String parentIdEntry : parentIds) {
            AssetNodeIdentifier assetId = AssetNodeIdentifier.valueOf(parentIdEntry);
            if (assetId.isRoot()) continue;
            if (!assetId.isDevice()) {
                this.addFieldValue(values, assetId.getLastFieldValue(), assetId.getLastFieldKey());
                continue;
            }
            if (SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_ALL)) {
                values.remove(AssetFields.FIELD_OWNER.getKey());
                inheritedFields.put(AssetFields.FIELD_OWNER.getKey(), AssetView.ValueSource.Parent);
            } else {
                GUID ownerId;
                AssetView asset = AssetManager.getInstance().getAsset(assetId.getDeviceId());
                if (asset != null && (ownerId = asset.getValue(AssetFields.FIELD_OWNER)) != null && ownerId.equals((Object)currentUserAccountID)) {
                    values.remove(AssetFields.FIELD_OWNER.getKey());
                    inheritedFields.put(AssetFields.FIELD_OWNER.getKey(), AssetView.ValueSource.Parent);
                }
            }
            values.remove(AssetFields.FIELD_COSTCENTER.getKey());
            values.remove(AssetFields.FIELD_LOCATION.getKey());
            values.remove(AssetFields.FIELD_ROOM.getKey());
            inheritedFields.put(AssetFields.FIELD_COSTCENTER.getKey(), AssetView.ValueSource.Parent);
            inheritedFields.put(AssetFields.FIELD_LOCATION.getKey(), AssetView.ValueSource.Parent);
            inheritedFields.put(AssetFields.FIELD_ROOM.getKey(), AssetView.ValueSource.Parent);
        }
        if (!parentIds.isEmpty() && (parentIdentifier = AssetNodeIdentifier.valueOf(parentKey = parentIds.get(parentIds.size() - 1))).isDevice()) {
            parentId = parentIdentifier.getDeviceId();
        }
        if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_ALL) && !inheritedFields.containsKey(AssetFields.FIELD_OWNER.getKey())) {
            String ownerSelectOption = (String)values.remove(AssetFields.FIELD_OWNER.getKey());
            if (ownerSelectOption != null) {
                ownerSelectOption = ((SelectOption)new Json().fromJson(ownerSelectOption, SelectOption.class)).getValue();
            }
            if (currentUserAccountID != null && !currentUserAccountID.toString().equals(ownerSelectOption)) {
                this.addFieldValue(values, currentUserAccountID.toString(), AssetFields.FIELD_OWNER.getKey());
            }
        }
        return new PrepareNewAssetResponse(values, inheritedFields, parentId);
    }

    private void addFieldValue(Map<String, String> values, String fieldValue, String fieldKey) {
        AssetField field = AssetFields.getFieldFor(fieldKey);
        if (field instanceof AssetFieldWithDefinition) {
            AssetFieldWithDefinition fieldWithDefinition = (AssetFieldWithDefinition)field;
            final MutableAssetData data = new MutableAssetData();
            data.put(field, fieldWithDefinition.valueOf(fieldValue));
            final GUID id = GUID.generateNew();
            AssetView device = new AssetView(){

                @Override
                public boolean isArchived() {
                    return false;
                }

                @Override
                @Nullable
                public <VALUE> VALUE getValue(AssetField<VALUE> field) {
                    return data.get(field);
                }

                @Override
                @Nonnull
                public GUID getId() {
                    return id;
                }

                @Override
                public List<GUID> getChildAssetIDs() {
                    return Collections.emptyList();
                }

                @Override
                public AssetView.ValueSource isInherited(AssetField<?> field) {
                    return AssetView.ValueSource.Asset;
                }

                @Override
                @Nullable
                public <VALUE> VALUE getOwnValue(AssetField<VALUE> field) {
                    return data.get(field);
                }
            };
            this.addFieldValue(values, device, fieldKey);
        }
    }

    private void addFieldValue(Map<String, String> values, AssetView device, String fieldKey) {
        String serializeValue;
        FieldEditInformation<?> editInformation;
        AssetFieldDefinition fieldDefinition = AssetFields.getFieldDefinitionFor(fieldKey);
        if (fieldDefinition != null && (editInformation = fieldDefinition.getEditInformation()) != null && (serializeValue = editInformation.serializeValue(device)) != null) {
            values.put(fieldKey, serializeValue);
        }
    }
}

