/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.event;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.plugins.inventory.client.InventoryAttachments;
import com.inet.helpdesk.plugins.inventory.client.data.AssetDetails;
import com.inet.helpdesk.plugins.inventory.client.data.AssetID;
import com.inet.helpdesk.plugins.inventory.client.data.HistoryEntry;
import com.inet.helpdesk.plugins.inventory.client.data.InitDetailsState;
import com.inet.helpdesk.plugins.inventory.client.data.InventoryAttachment;
import com.inet.helpdesk.plugins.inventory.client.event.AbstractInventoryEvent;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.HistoryStep;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinitionLink;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.FieldEditInformation;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.AssetNodeIdentifier;
import com.inet.helpdesk.plugins.inventory.server.api.tree.AssetClientListener;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.http.websocket.WebSocketConnectionListener;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.http.websocket.WebsocketConnection;
import com.inet.id.GUID;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class InitInventoryDetails
extends AbstractInventoryEvent<InitDetailsState> {
    public InitInventoryDetails() {
        WebSocketEventHandler.getInstance().addConnectionListener(new WebSocketConnectionListener(){

            public void connectionOpened(String clientId) {
            }

            public void connectionClosed(String clientId) {
                AssetManager.getInstance().view().unregisterAssetClient(clientId);
            }
        });
    }

    @Override
    public void handleEvent(final WebSocketEventHandler eventHandler, final WebsocketConnection websocketConnection, InitDetailsState payload) throws IOException {
        AssetManager.getInstance().view().unregisterAssetClient(websocketConnection.getPollingID());
        if (payload.getId() == null) {
            return;
        }
        AssetNodeIdentifier id = null;
        try {
            id = AssetNodeIdentifier.valueOf(payload.getId());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (id == null || !id.isDevice() || !id.toString().equals(payload.getId())) {
            eventHandler.sendEvent(websocketConnection.getPollingID(), () -> new WebSocketEventData("inventory.details.error", (Object)new LocalizedKey(payload.getId(), InventoryServerPlugin.CLIENT_MSG.getMsg("inventory.notanasset", new Object[0]))));
            return;
        }
        AssetManager.getInstance().view().registerAssetClient(websocketConnection.getPollingID(), id.getDeviceId(), payload.isSyncWithTree(), new AssetClientListener(){

            @Override
            public void assetChanged(String clientId, GUID assetID, @Nullable AssetView asset) {
                Supplier<WebSocketEventData> eventFactory = () -> {
                    if (asset == null) {
                        return new WebSocketEventData("inventory.details.error", (Object)new LocalizedKey(assetID.toString(), InventoryServerPlugin.CLIENT_MSG.getMsg("inventory.assetnotfound", new Object[0])));
                    }
                    AssetDetails details = InitInventoryDetails.createAssetDetails(asset);
                    return new WebSocketEventData("inventory.details.update", (Object)details);
                };
                WebSocketEventHandler.getInstance().sendEvent(websocketConnection.getPollingID(), eventFactory);
            }

            @Override
            public void sendError(String clientId, Throwable error, GUID assetId) {
                eventHandler.sendEvent(clientId, () -> new WebSocketEventData("inventory.details.error", (Object)new LocalizedKey(assetId.toString(), StringFunctions.getUserFriendlyErrorMessage((Throwable)error))));
            }
        });
    }

    public static AssetDetails createAssetDetails(AssetView asset) {
        boolean hasChildren;
        AssetID assid = new AssetID(true, asset.getId().toString());
        HashMap<String, String> values = new HashMap<String, String>();
        HashMap<String, AssetView.ValueSource> inheritedFields = new HashMap<String, AssetView.ValueSource>();
        HashMap<String, String> hyperlinks = new HashMap<String, String>();
        values.put(AssetFields.FIELD_INT_ID.getKey(), String.valueOf(asset.getIntID()));
        String assetImage = asset.getValue(AssetFields.FIELD_IMAGE);
        values.put(AssetFields.FIELD_IMAGE.getKey(), assetImage);
        Integer typeId = asset.getValue(AssetFields.FIELD_TYPE);
        values.put("typeid", typeId == null ? null : typeId.toString());
        List definitions = DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class);
        for (AssetFieldDefinition definition : definitions) {
            InitInventoryDetails.addFieldValue(values, inheritedFields, hyperlinks, asset, definition.getFieldKey());
        }
        String iconKey = InitInventoryDetails.getAssetIconKey(asset);
        GUID parentID = asset.getParentID();
        AssetDetails parent = null;
        if (parentID != null) {
            try {
                AssetView parentAsset = AssetManager.getInstance().getAsset(parentID);
                if (parentAsset != null) {
                    String parentIconKey = InitInventoryDetails.getAssetIconKey(parentAsset);
                    parent = new AssetDetails(new AssetID(true, parentAsset.getId().toString()), parentAsset.getName(), parentIconKey, parentAsset.isArchived(), null, null, null, null, null, null, true, true);
                }
            }
            catch (AccessDeniedException parentAsset) {
                // empty catch block
            }
        }
        boolean hasSubAssets = hasChildren = !asset.getChildAssetIDs().isEmpty();
        ArrayList<HistoryEntry> history = new ArrayList();
        List<HistoryStep> assetHistory = AssetManager.getInstance().getAssetHistory(asset.getId());
        if (assetHistory != null) {
            history = assetHistory.stream().map(h -> new HistoryEntry(h.getUser(), h.getChange(), h.getDate())).collect(Collectors.toList());
        }
        List<Object> attachments = new ArrayList();
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            attachments = InventoryAttachments.getAttachments(asset.getId());
            if (assetImage != null) {
                boolean imageFound = false;
                for (InventoryAttachment inventoryAttachment : attachments) {
                    if (!assetImage.equals(inventoryAttachment.getFileName())) continue;
                    if (!InventoryAttachments.isAttachmentAvailable(inventoryAttachment)) break;
                    imageFound = true;
                    break;
                }
                if (!imageFound) {
                    values.put(AssetFields.FIELD_IMAGE.getKey(), "");
                }
            }
        }
        return new AssetDetails(assid, asset.getName(), iconKey, asset.isArchived(), values, inheritedFields, hyperlinks, attachments, history, parent, hasChildren, hasSubAssets);
    }

    private static String getAssetIconKey(AssetView asset) {
        return "field=" + EncodingFunctions.encodeUrlParameter((String)AssetFields.FIELD_TYPE.getKey()) + "&value=" + EncodingFunctions.encodeUrlParameter((String)String.valueOf(asset.getValue(AssetFields.FIELD_TYPE)));
    }

    private static void addFieldValue(Map<String, String> values, Map<String, AssetView.ValueSource> inheritedFields, Map<String, String> hyperlinks, AssetView asset, String fieldKey) {
        FieldEditInformation<?> editInformation;
        AssetFieldDefinition fieldDefinition = AssetFields.getFieldDefinitionFor(fieldKey);
        if (fieldDefinition != null && (editInformation = fieldDefinition.getEditInformation()) != null) {
            AssetField field;
            AssetView.ValueSource inherited;
            String serializeValue = editInformation.serializeValue(asset);
            if (serializeValue != null) {
                AssetFieldDefinitionLink assetFieldDefinitionLink;
                String hyperlink;
                values.put(fieldKey, serializeValue);
                if (fieldDefinition instanceof AssetFieldDefinitionLink && !StringFunctions.isEmpty((String)(hyperlink = (assetFieldDefinitionLink = (AssetFieldDefinitionLink)fieldDefinition).getHyperlink(asset)))) {
                    hyperlinks.put(fieldKey, hyperlink);
                }
            }
            if ((inherited = asset.isInherited(field = AssetFields.getFieldFor(fieldKey))) != AssetView.ValueSource.Asset) {
                inheritedFields.put(fieldKey, inherited);
            }
        }
    }

    public String getEventName() {
        return "inventory.details.init";
    }
}

