/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.field.ConfigurableField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeVO;
import com.inet.helpdesk.plugins.inventory.server.webapi.data.InventoryAssetType;
import com.inet.helpdesk.plugins.inventory.server.webapi.util.InventoryWebAPIHelper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@JsonData
@Schema(description="Represents an asset type with its associated field keys")
public class InventoryAssetTypeEntry
extends InventoryAssetType {
    @Schema(description="List of field keys associated with this asset type")
    private List<String> fields;

    public InventoryAssetTypeEntry(int id, String name) {
        super(id, name);
    }

    @Nonnull
    public static InventoryAssetTypeEntry from(AssetTypeVO assetType) {
        InventoryAssetTypeEntry entry = new InventoryAssetTypeEntry(assetType.getId(), assetType.getDisplayValue());
        List<AssetFieldDefinition> fields = InventoryWebAPIHelper.getAvailableAssetFields(assetType);
        entry.fields = fields.stream().map(ConfigurableField::getFieldKey).collect(Collectors.toList());
        return entry;
    }
}

