/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.taskplanner.trigger;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.taskplanner.i18n.InventoryTaskPlannerMsg;
import com.inet.helpdesk.plugins.inventory.server.taskplanner.trigger.LowHighInventoryTrigger;
import com.inet.id.GUID;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.NumberField;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.api.trigger.TriggerInfo;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LowHighInventoryTriggerFactory
extends TriggerFactory<LowHighInventoryTrigger> {
    public static final String EXTENSION_NAME = "taskplanner.inventory.trigger";
    public static final String PROPERTY_QUERY = "query";
    public static final String PROPERTY_GREATER_OR_SMALLER = "greaterOrSmaller";
    public static final String PROPERTY_HOW_MANY = "howMany";
    public static final String PROPERTY_VALUE_GREATER = "greater";
    public static final String PROPERTY_VALUE_SMALLER = "smaller";

    public LowHighInventoryTriggerFactory() {
        super(EXTENSION_NAME);
    }

    public TriggerInfo getInformation(@Nullable GUID guid) {
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/images/lowinventory_32.png");
        ArrayList placeholders = new ArrayList();
        return new TriggerInfo(EXTENSION_NAME, InventoryTaskPlannerMsg.MSG.getMsg("InventoryTrigger.name", new Object[0]), InventoryTaskPlannerMsg.MSG.getMsg("InventoryTrigger.desc", new Object[0]), iconURL, "taskplanner.trigger.lowhighinventory", this.createFields(), placeholders);
    }

    private List<Field> createFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        TextField queryField = new TextField(PROPERTY_QUERY, InventoryTaskPlannerMsg.MSG.getMsg("trigger.inventory.query", new Object[0]));
        fields.add((Field)queryField);
        ArrayList<LocalizedKey> values = new ArrayList<LocalizedKey>();
        values.add(new LocalizedKey(PROPERTY_VALUE_GREATER, InventoryTaskPlannerMsg.MSG.getMsg("trigger.inventory.greater", new Object[0])));
        values.add(new LocalizedKey(PROPERTY_VALUE_SMALLER, InventoryTaskPlannerMsg.MSG.getMsg("trigger.inventory.smaller", new Object[0])));
        SelectField greaterOrSmallerField = new SelectField(PROPERTY_GREATER_OR_SMALLER, InventoryTaskPlannerMsg.MSG.getMsg("trigger.inventory.greaterOrSmaller", new Object[0]), values);
        greaterOrSmallerField.setValue(PROPERTY_VALUE_GREATER);
        fields.add((Field)greaterOrSmallerField);
        NumberField howManyField = new NumberField(PROPERTY_HOW_MANY, InventoryTaskPlannerMsg.MSG.getMsg("trigger.inventory.howMany", new Object[0]));
        howManyField.setValue("0");
        fields.add((Field)howManyField);
        return fields;
    }

    public void validate(@Nonnull TriggerDefinition definition, GUID taskID) throws ValidationException {
        String howManyStr = definition.getProperty(PROPERTY_HOW_MANY);
        if (howManyStr == null || howManyStr.trim().isEmpty()) {
            throw new ValidationException(new String[]{InventoryTaskPlannerMsg.MSG.getMsg("trigger.inventory.error.noHowMany", new Object[0])});
        }
        try {
            int howMany = Integer.parseInt(howManyStr);
            if (howMany < 0) {
                throw new ValidationException(new String[]{InventoryTaskPlannerMsg.MSG.getMsg("trigger.inventory.error.howManyNegative", new Object[0])});
            }
        }
        catch (NumberFormatException e) {
            throw new ValidationException(new String[]{InventoryTaskPlannerMsg.MSG.getMsg("trigger.inventory.error.howManyNegative", new Object[0])});
        }
    }

    public SummaryInfo getSummary(@Nonnull TriggerDefinition definition) {
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        String query = definition.getProperty(PROPERTY_QUERY);
        String greaterOrSmaller = definition.getProperty(PROPERTY_GREATER_OR_SMALLER);
        String howManyStr = definition.getProperty(PROPERTY_HOW_MANY);
        String comparison = PROPERTY_VALUE_GREATER.equals(greaterOrSmaller) ? InventoryTaskPlannerMsg.MSG.getMsg("trigger.inventory.moreThan", new Object[0]) : InventoryTaskPlannerMsg.MSG.getMsg("trigger.inventory.lessThan", new Object[0]);
        Integer howMany = 0;
        if (howManyStr != null && !howManyStr.isBlank()) {
            howMany = Integer.valueOf(howManyStr);
        }
        String summaryText = InventoryTaskPlannerMsg.MSG.getMsg("trigger.inventory.summary", new Object[]{comparison, howMany, query});
        IndexSearchEngine searchEngine = this.getAssetManager().getSearchEngine();
        SearchCommand command = new TextSearchCommandBuilder(searchEngine, query).build();
        int size = searchEngine.simpleSearch(command).size();
        summary.add(new SummaryEntry(InventoryTaskPlannerMsg.MSG.getMsg("trigger.inventory.currentResults", new Object[]{size}), summaryText));
        return new SummaryInfo(summary);
    }

    protected AssetManager getAssetManager() {
        return AssetManager.getInstance();
    }

    protected LowHighInventoryTrigger createInstanceFrom(@Nonnull TriggerDefinition definition, @Nullable GUID taskID) {
        return new LowHighInventoryTrigger(taskID, definition.getUid(), definition.getProperties());
    }
}

