/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.plugin.setup;

import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepKey;
import com.inet.shared.utils.Version;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;

public class InstallReportsStep
extends AutoSetupStep {
    public static final StepKey KEY = new StepKey("installinventoryreports");
    ArrayList<String> reports = new ArrayList<String>(){
        {
            this.add("inventory_printassetdetails.rpt");
            this.add("inventory_printselectedassets.rpt");
            this.add("inventory_printcodesforselectedassets.rpt");
        }
    };

    public StepKey stepKey() {
        return KEY;
    }

    public String getStepDisplayName() {
        return AssetManager.MSG.getMsg("setup.installinventoryreports.displayname", new Object[0]);
    }

    public boolean hasPendingTasks() {
        return true;
    }

    public SetupStep.ExecutionRestriction getExecutionRestriction() {
        return SetupStep.ExecutionRestriction.ONCE_PER_SETUP;
    }

    @Nullable
    public Version getMigrationVersion() {
        if (this.getLastMigratedVersionOfThisPlugin() == null) {
            return null;
        }
        return ServerPluginManager.getInstance().getPluginDescription("inventory").getVersion();
    }

    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        PersistenceEntry printDirLocation = AppDataLocation.getPrintDirLocation();
        for (String reportName : this.reports) {
            PersistenceEntry reportEntry = printDirLocation.resolve(reportName);
            try {
                InputStream entryStream = reportEntry.getInputStream();
                try {
                    if (reportEntry.exists() && !this.isOriginalReportFile(entryStream)) continue;
                    URL reportUrl = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/plugin/setup/reports/" + reportName);
                    if (reportUrl != null) {
                        try {
                            InputStream in = reportUrl.openStream();
                            try {
                                printDirLocation.resolve(reportName).setInputStream(in);
                                continue;
                            }
                            finally {
                                if (in == null) continue;
                                in.close();
                                continue;
                            }
                        }
                        catch (IOException e) {
                            throw new StepExecutionException("Error copying report file", (Throwable)e);
                        }
                    }
                    throw new StepExecutionException("Report URL is null for report name: " + reportName);
                }
                finally {
                    if (entryStream == null) continue;
                    entryStream.close();
                }
            }
            catch (IOException e1) {
                throw new StepExecutionException("Source Report URL is null for report name: " + reportName);
            }
        }
    }

    public SetupStepPriority getPriority() {
        return new SetupStepPriority(5630);
    }

    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> AssetManager.MSG.getMsg("setup.installinventoryreports.displayname", new Object[0]);
    }

    public boolean willPerformIrreversibleMigration(EmptyStepConfig settings) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isOriginalReportFile(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream cannot be null");
        }
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                if (entry.getName().equals("i-net mark")) {
                    boolean bl = true;
                    return bl;
                }
                zipInputStream.closeEntry();
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

