/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.internal.tree;

import com.inet.helpdesk.plugins.inventory.server.api.model.tree.settings.ClientTreeSettings;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.InternalTreeNode;
import com.inet.id.GUID;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public class StructureInfo {
    private int currentDepth = 0;
    private int maxDepth;
    private TYPE type;
    private AtomicInteger numberOfNodes = new AtomicInteger(0);
    private int nodeLimit;
    private InternalTreeNode currentStructure;
    private Comparator<GUID> comparator;
    private ClientTreeSettings settings;

    public StructureInfo(int maxDepth, TYPE type, int nodeLimit, ClientTreeSettings settings, InternalTreeNode currentStructure) {
        this.maxDepth = maxDepth;
        this.type = type;
        this.settings = settings;
        this.currentStructure = currentStructure;
        this.nodeLimit = nodeLimit;
    }

    public int getCurrentDepth() {
        return this.currentDepth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public StructureInfo deeper() {
        StructureInfo structureInfo = new StructureInfo(this.maxDepth, this.type, this.nodeLimit, this.settings, this.currentStructure);
        structureInfo.currentDepth = this.currentDepth + 1;
        structureInfo.numberOfNodes = this.numberOfNodes;
        structureInfo.comparator = this.comparator;
        return structureInfo;
    }

    public TYPE getType() {
        return this.type;
    }

    public void addedNode() {
        this.numberOfNodes.incrementAndGet();
    }

    public boolean limitReached() {
        return this.numberOfNodes.get() >= this.nodeLimit;
    }

    @Nullable
    public InternalTreeNode getCurrentStructure() {
        return this.currentStructure;
    }

    public int getNodeLimit() {
        return this.nodeLimit;
    }

    @Nullable
    Comparator<GUID> getComparator() {
        return this.comparator;
    }

    void setComparator(Comparator<GUID> comparator) {
        this.comparator = comparator;
    }

    public ClientTreeSettings getSettings() {
        return this.settings;
    }

    public static enum TYPE {
        Tree,
        Structure;

    }
}

