/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.internal;

import com.inet.helpdesk.plugins.inventory.server.api.model.AssetVO;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.id.GUID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AssetVOImpl
implements AssetVO {
    private GUID id;
    private MutableAssetData data;
    private boolean archived;
    private List<GUID> childIDs;

    AssetVOImpl(@Nonnull GUID id, @Nonnull MutableAssetData data, boolean archived, @Nonnull List<GUID> childIDs) {
        this.id = id;
        this.archived = archived;
        this.childIDs = new ArrayList<GUID>(childIDs);
        this.data = data.copy();
    }

    @Override
    public <VALUE> VALUE getValue(AssetField<VALUE> field) {
        if (field.isDefaultValueAppliesToNull()) {
            return this.data.getOrDefault(field);
        }
        return this.data.get(field);
    }

    @Override
    @Nonnull
    public GUID getId() {
        return this.id;
    }

    @Override
    public boolean isArchived() {
        return this.archived;
    }

    @Override
    public List<GUID> getChildAssetIDs() {
        return Collections.unmodifiableList(this.childIDs);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.archived ? 1231 : 1237);
        result = 31 * result + (this.childIDs == null ? 0 : this.childIDs.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssetVOImpl other = (AssetVOImpl)obj;
        if (this.archived != other.archived) {
            return false;
        }
        if (this.childIDs == null ? other.childIDs != null : !this.childIDs.equals(other.childIDs)) {
            return false;
        }
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals((Object)other.id));
    }

    public MutableAssetData asAssetDataRepresentation() {
        return this.data.copy();
    }
}

