/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.eventlog;

import com.inet.classloader.I18nMessages;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.id.GUID;
import com.inet.logging.EventLog;
import java.util.List;
import java.util.Locale;

public enum AssetEventLog {
    AssetCreated,
    AssetChanged,
    AssetDeleted,
    AssetArchived,
    AssetUnarchived;

    private static final EventLog<AssetEventLog> EVENT_LOG;
    static final I18nMessages MSG;

    public void log(AssetView asset) {
        this.log(asset, null);
    }

    public void log(AssetView asset, List<AssetField<Object>> affectedFields) {
        StringBuilder param;
        int count = 0;
        if (affectedFields != null) {
            param = new StringBuilder();
            for (AssetField<Object> assetField : affectedFields) {
                if (param.length() > 0) {
                    param.append(", ");
                }
                param.append(assetField.getLabel());
                ++count;
            }
        } else {
            param = null;
        }
        String msg = MSG.getMsg(Locale.getDefault(), "eventlog." + this.name(), new Object[]{count, param});
        GUID id = asset.getId();
        String name = asset.getName();
        EVENT_LOG.log((Enum)this, msg, null, new Object[]{id, name});
    }

    static {
        EVENT_LOG = EventLog.register((String)"asset");
        MSG = new I18nMessages("com.inet.helpdesk.plugins.inventory.server.eventlog.i18n.LanguageResources", AssetEventLog.class);
    }
}

