/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts;

import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithConfigurableDefault;
import com.inet.usersandgroups.api.BasicFieldValidation;
import javax.annotation.Nullable;

public class AssetField_String
extends AssetFieldWithConfigurableDefault<String> {
    private int maxlength;

    public AssetField_String(String key, String defaultValue, int sortPrio, FieldSettingsType displayType, int maxlength) {
        super(key, defaultValue, sortPrio, displayType, FieldTypeFactory.auto());
        switch (key) {
            case "custom1": 
            case "custom2": 
            case "custom3": {
                this.maxlength = 50;
                break;
            }
            case "custom4": 
            case "custom5": {
                this.maxlength = 255;
                break;
            }
            case "custom6": 
            case "custom7": 
            case "custom8": 
            case "custom9": {
                this.maxlength = 100;
                break;
            }
            default: {
                this.maxlength = maxlength;
            }
        }
    }

    public void validate(String value) {
        super.validate((Object)value);
        if (value != null && this.maxlength != -1) {
            BasicFieldValidation.throwIfLengthExceedsLimit((String)value, (int)this.maxlength);
        }
    }

    @Override
    public void setDefaultValue(@Nullable String value) {
        this.setDefaultValueInField(value);
    }
}

