/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts;

import com.inet.field.Field;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.GuidTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.usersandgroups.api.FieldValidationException;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class AssetField<VALUE>
extends Field<VALUE> {
    private SearchTag entrySearchTag = null;
    private boolean defaultValueAppliesToNull;

    public AssetField(String key, VALUE defaultValue, FieldTypeFactory factory) {
        super(key, defaultValue, factory);
        SearchDataType searchDataType;
        SearchTag searchTag = this.getSearchTag();
        SearchDataType searchDataType2 = searchDataType = searchTag != null ? searchTag.getDataType() : null;
        if (searchDataType != null) {
            switch (searchDataType) {
                case String: 
                case StringMap: {
                    this.entrySearchTag = new SearchTag(this.getKey() + "_entry", SearchDataType.ID, true, (SearchTokenizer)new Tokenizer(), 10){

                        public boolean showAlsoNonMapValues() {
                            return searchDataType == SearchDataType.StringMap;
                        }
                    };
                    break;
                }
            }
        }
    }

    @Nullable
    public VALUE getValueFromIndexedValue(@Nullable Object indexedValue) {
        if (indexedValue == null) {
            return null;
        }
        return (VALUE)indexedValue;
    }

    @Nullable
    public final SearchTag getEntrySearchTag() {
        if (this.entrySearchTag != null) {
            return this.entrySearchTag;
        }
        return this.getSearchTag();
    }

    public final boolean hasEntrySearchTag() {
        return this.entrySearchTag != null;
    }

    public void validateRealValue(VALUE value) throws FieldValidationException {
        this.validate(value);
    }

    public String createFieldChangeStepText(VALUE oldValue, VALUE newValue) {
        return null;
    }

    public final String getEntrySearchKey() {
        if (this.entrySearchTag != null) {
            return this.entrySearchTag.getTag();
        }
        return this.getKey();
    }

    public boolean isDefaultValueAppliesToNull() {
        return this.defaultValueAppliesToNull;
    }

    public void setDefaultValueAppliesToNull(boolean defaultValueAppliesToNull) {
        this.defaultValueAppliesToNull = defaultValueAppliesToNull;
    }

    public void setDefaultValue(VALUE value) {
        if (value != null && !value.equals("")) {
            this.validate(value);
        }
        super.setDefaultValue(value);
    }

    private class Tokenizer
    extends GuidTokenizer {
        private Tokenizer() {
        }

        public Set<String> tokens(Object value, int type) {
            if (type == 3 && value == null) {
                return Collections.singleton(null);
            }
            return super.tokens(value, type);
        }
    }
}

