/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model.field;

import com.inet.field.FieldUtils;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetVO;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithIcon;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_Select_Int;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeVO;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.FieldValidationException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AssetFieldType
extends AssetField_Select_Int
implements AssetFieldWithIcon<Integer> {
    public AssetFieldType(String key, int sortPrio) {
        super(key, null, sortPrio);
        this.setMandatory(true);
    }

    public List<SelectOption> getSelectOptions(boolean includeDeleted) {
        List all = AssetTypeManager.getInstance().getAll(!includeDeleted);
        List arrayList = all.stream().map(dt -> this.selectOption((AssetTypeVO)((Object)dt))).collect(Collectors.toCollection(ArrayList::new));
        return arrayList;
    }

    @Override
    public SelectOption getValue(AssetView asset) {
        SelectOption value = super.getValue(asset);
        if (value == null || value.getValue() == null) {
            value = this.getSelectOptions().get(0);
        }
        return value;
    }

    @Override
    public SelectOptionResult getOptions(AssetVO asset, String searchTerm, int currentSize, int chunkSize) {
        Map options = this.getSearchTag().getMapData();
        return FieldUtils.getOptions((String)searchTerm, (int)currentSize, (int)chunkSize, (Map)options, (value, displayName) -> new SelectOption(StringFunctions.stringValueOf((Object)value), displayName, String.valueOf(value)));
    }

    private SelectOption selectOption(AssetTypeVO assetTypeVO) {
        return new SelectOption(String.valueOf(assetTypeVO.getId()), assetTypeVO.getDisplayValue(), String.valueOf(assetTypeVO.getId()));
    }

    @Override
    public String getDisplayValue(Integer value) {
        AssetTypeVO type = (AssetTypeVO)AssetTypeManager.getInstance().get(value);
        if (type != null) {
            return type.getDisplayValue();
        }
        return null;
    }

    @Override
    public void validateRealValue(Integer id) throws FieldValidationException {
        if (id != null && AssetTypeManager.getInstance().get(id) == null) {
            throw new IllegalArgumentException("No type exists for given id: " + id);
        }
    }

    @Override
    public URL getIcon(String value, int size) {
        try {
            int type = Integer.parseInt(value);
            return AssetTypeManager.getInstance().getIcon(type, size);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getIcon(value, size);
        }
    }
}

