/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api;

import com.inet.classloader.translations.TranslationKey;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.field.ConfigurableField;
import com.inet.field.FieldManager;
import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeDate;
import com.inet.field.fieldtypes.FieldTypeSelect_String;
import com.inet.field.fieldtypes.HasSelectOptions;
import com.inet.fieldsettings.api.AbstractFieldSettingsManager;
import com.inet.fieldsettings.api.FieldSettingsStructureInfo;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.api.model.nature.CustomNature;
import com.inet.fieldsettings.api.model.nature.GenericFieldNature;
import com.inet.fieldsettings.api.model.nature.RegisteredNature;
import com.inet.helpdesk.core.ticketfieldsettings.SqlQuerySelectValueProvider;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettingsManager;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinitionLink;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithConfigurableDefault;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_Boolean;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_Currency;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_DateTime;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_Double;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_Integer;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_Select;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_String;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_Time;
import com.inet.helpdesk.plugins.inventory.server.config.InventoryGenericFieldsStructureProvider;
import com.inet.helpdesk.plugins.inventory.server.internal.fieldsettings.nature.RegisteredAssetNature;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.plugin.DynamicExtensionManager;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssetFieldSettingsManager
extends AbstractFieldSettingsManager<AssetFieldDefinition, AssetFieldWithDefinition<?>> {
    private static final AssetFieldSettingsManager INSTANCE = new AssetFieldSettingsManager();

    public AssetFieldSettingsManager() {
        super("AssetFields", InventoryServerPlugin.LOGGER);
    }

    public static AssetFieldSettingsManager getInstance() {
        return INSTANCE;
    }

    public void init() {
        super.init();
        if (this.getSetting("custom1") == null) {
            List<String> toadd = List.of("custom1", "custom2", "custom3", "custom4", "custom5", "custom6", "custom7", "custom8", "custom9");
            for (String key : toadd) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("fieldsettingsKey", key);
                properties.put("sortPrio", String.valueOf(26 + toadd.indexOf(key)));
                properties.put("type", FieldSettingsType.TYPE_TEXT.toString());
                Map<String, String> translations = Map.of("default", AssetManager.MSG.getMsg(Locale.ENGLISH, "device.field." + key, new Object[0]), "de", AssetManager.MSG.getMsg(Locale.GERMAN, "device.field." + key, new Object[0]));
                this.setSpecificDefaultValues(null, properties);
                GenericFieldSetting setting = new GenericFieldSetting(key, true, "", (GenericFieldNature)new CustomNature(properties), properties);
                Map.Entry customField = this.saveNewCustomSetting(key, setting);
                this.registerTranslationKeys((AssetFieldDefinition)customField.getKey());
                this.updateLabelsOfField(new Json().toJson(translations), new Json().toJson(Map.of()), setting);
                this.updateConfigurableValuesOfField((AssetFieldDefinition)customField.getKey(), setting);
            }
        }
    }

    protected void handleUnknownRegisteredField(GenericFieldSetting setting) {
        if (AssetFields.isOpenField(setting.getKey())) {
            String key = setting.getKey();
            InventoryServerPlugin.LOGGER.info((Object)("[Update] Convert open asset field " + key + " to custom format."));
            HashMap<String, String> rowProps = new HashMap<String, String>();
            rowProps.put("fieldsettingsKey", key);
            rowProps.put("type", FieldSettingsType.TYPE_TEXT.toString());
            rowProps.put("sortPrio", String.valueOf(setting.getSortPriority()));
            rowProps.putAll(setting.getSpecificProperties());
            TranslationKey baseKey = new TranslationKey("inventory", AssetManager.MSG.getBundle().getBaseBundleName(), "en", "device.field." + key);
            String fieldLabelsJson = new Json().toJson((Object)setting.loadLabelsFromResourceManager(baseKey));
            TranslationKey descriptionKey = new TranslationKey(baseKey.pluginId, baseKey.bundleName, baseKey.language, baseKey.key + ".description");
            String fieldDescriptionsJson = new Json().toJson((Object)setting.loadLabelsFromResourceManager(descriptionKey));
            GenericFieldSetting newSetting = new GenericFieldSetting(key, true, setting.getDefaultValue(), (GenericFieldNature)new CustomNature(rowProps), rowProps);
            Map.Entry customField = this.saveNewCustomSetting(key, newSetting);
            this.registerTranslationKeys((AssetFieldDefinition)customField.getKey());
            this.updateLabelsOfField(fieldLabelsJson, fieldDescriptionsJson, newSetting);
            this.updateConfigurableValuesOfField((AssetFieldDefinition)customField.getKey(), newSetting);
        } else {
            super.handleUnknownRegisteredField(setting);
        }
    }

    protected <T> Map.Entry<AssetFieldDefinition, AssetFieldWithDefinition<?>> createAndRegisterForCustom(final GenericFieldSetting setting) {
        final String key = setting.getKey();
        int prio = setting.getSortPriority();
        final FieldSettingsType type = setting.getType();
        AssetFieldWithConfigurableDefault field = null;
        AssetFieldDefinition def = null;
        if (type == FieldSettingsType.TYPE_DOUBLE) {
            def = field = new AssetField_Double(key, null, prio);
        } else if (type == FieldSettingsType.TYPE_CURRENCY) {
            def = field = new AssetField_Currency(key, null, prio);
        } else if (type == FieldSettingsType.TYPE_TEXT || type == FieldSettingsType.TYPE_MULTILINE_TEXT) {
            def = field = new AssetField_String(key, null, prio, type, -1);
        } else if (type == FieldSettingsType.TYPE_DATE || type == FieldSettingsType.TYPE_DATE_TIME) {
            def = field = new AssetField_DateTime(key, null, prio, type != FieldSettingsType.TYPE_DATE){

                @Override
                @Nonnull
                public FieldType<Long> createFieldType() {
                    return new FieldTypeDate(this.getKey(), () -> this.getLabel(), type != FieldSettingsType.TYPE_DATE){

                        public boolean withTimezone() {
                            return !"true".equalsIgnoreCase(setting.getSpecificProperty("fieldSettingsIgnoreTimezone"));
                        }
                    };
                }
            };
        } else if (type == FieldSettingsType.TYPE_TIME) {
            def = field = new AssetField_Time(key, null, prio);
        } else if (type == FieldSettingsType.TYPE_BOOLEAN) {
            def = field = new AssetField_Boolean(key, null, prio);
        } else if (type == FieldSettingsType.TYPE_NUMBER) {
            def = field = new AssetField_Integer(key, null, prio);
        } else if (type == FieldSettingsType.TYPE_SELECT) {
            def = field = new AssetField_Select<String>(key, null, prio){

                @Nonnull
                public FieldType<String> createFieldType() {
                    return new FieldTypeSelect_String(key, () -> this.getLabel(), (HasSelectOptions)this);
                }

                public List<SelectOption> getSelectOptions(boolean includeDeleted) {
                    return setting.getNature().getSelectOptions(null, setting);
                }

                @Override
                public SelectOption getValue(AssetView device) {
                    String value = device != null ? device.getValue(this) : (String)this.getDefaultValue();
                    return new SelectOption(value, value);
                }

                @Override
                public void setDefaultValue(@Nullable String value) {
                    super.setDefaultValueInField(value);
                }

                @Override
                public boolean allowsMultipleValues() {
                    return ((CustomNature)setting.getNature()).getSelectOptionsMode() == 3;
                }

                @Override
                public boolean allowsCustomValue() {
                    return ((CustomNature)setting.getNature()).getSelectOptionsMode() == 2;
                }
            };
        } else if (type == FieldSettingsType.TYPE_LINK) {
            def = new AssetFieldDefinitionLink(setting);
        } else {
            throw new UnsupportedOperationException("type=" + String.valueOf(type));
        }
        DynamicExtensionManager dem = DynamicExtensionManager.getInstance();
        if (field != null) {
            dem.register(AssetField.class, (Object)field);
        }
        dem.register(AssetFieldDefinition.class, (Object)def);
        HashMap<AssetField_Double, AssetField_Double> xx = new HashMap<AssetField_Double, AssetField_Double>();
        xx.put((AssetField_Double)def, (AssetField_Double)field);
        return xx.entrySet().iterator().next();
    }

    protected List<AssetFieldDefinition> getAllRegisteredDefinitions() {
        List all = DynamicExtensionManager.getInstance().get(AssetField.class);
        ArrayList<AssetFieldDefinition> result = new ArrayList<AssetFieldDefinition>();
        all.forEach(def -> {
            if (!(def instanceof AssetFieldWithDefinition)) {
                return;
            }
            try {
                RegisteredAssetNature.getTypeForDefinition((AssetFieldWithDefinition)def);
            }
            catch (IllegalArgumentException notsupportet) {
                return;
            }
            result.add((AssetFieldWithDefinition)def);
        });
        return result;
    }

    public List<FieldSettingsType> getSupportedTypesForCustomFields() {
        List supportedTypesForCustomFields = super.getSupportedTypesForCustomFields();
        return supportedTypesForCustomFields;
    }

    public FieldSettingsStructureInfo getFieldSettingsStructureInfo() {
        return new FieldSettingsStructureInfo(BASE_TRANSLATIONS){

            public String getIconKeyRegisteredField() {
                return "device_normal";
            }

            public String getIconKeyCustomField() {
                return "device_custom";
            }

            public String getHelpKey() {
                return "field.settings.device.edit";
            }

            public String getFieldKindLabel() {
                return AssetManager.MSG.getMsg("field.device.title", new Object[0]);
            }
        };
    }

    protected AssetFieldWithDefinition<?> getIndexInfoForRegisteredField(AssetFieldDefinition definition) {
        return (AssetFieldWithDefinition)definition;
    }

    protected RegisteredNature<?> getRegisteredNatureFor(AssetFieldDefinition arg0) {
        return new RegisteredAssetNature((AssetFieldWithDefinition)arg0);
    }

    protected String setSpecificDefaultValues(@Nullable AssetFieldDefinition registeredDefinition, Map<String, String> properties) {
        if (registeredDefinition != null) {
            AssetFieldWithDefinition regField = (AssetFieldWithDefinition)registeredDefinition;
            properties.putIfAbsent("prop_default_replaces_null", String.valueOf(regField.isDefaultValueAppliesToNull()));
            properties.putIfAbsent("prop_mandatory", String.valueOf(regField.isMandatory()));
            properties.putIfAbsent("prop_visible_if", new Json().toJson(registeredDefinition.getVisibleIfTypeIs().stream().map(Object::toString).map(s -> Collections.singletonList(s)).collect(Collectors.toList())));
            Object defaultValue = regField.getDefaultValue();
            if (defaultValue != null) {
                return defaultValue.toString();
            }
            return null;
        }
        properties.putIfAbsent("prop_default_replaces_null", String.valueOf(false));
        properties.putIfAbsent("prop_mandatory", String.valueOf(false));
        properties.putIfAbsent("prop_visible_if", new Json().toJson(Collections.singletonList(Collections.singletonList(String.valueOf(-2)))));
        SqlQuerySelectValueProvider.setDefaultValuesForSqlProperties(properties);
        return null;
    }

    protected AssetFieldWithDefinition<?> unregisterForCustom(GenericFieldSetting setting) {
        List list = DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class);
        Optional<AssetFieldDefinition> field = list.stream().filter(f -> f.getFieldKey().equals(setting.getKey())).findFirst();
        if (!field.isPresent()) {
            InventoryServerPlugin.LOGGER.warn((Object)("Cannot find field to unregister: " + setting.getKey()));
            return null;
        }
        if (field.get() instanceof AssetField) {
            DynamicExtensionManager.getInstance().unregister(AssetField.class, (Object)((AssetField)((Object)field.get())));
        }
        DynamicExtensionManager.getInstance().unregister(AssetFieldDefinition.class, (Object)field.get());
        if (field.get() instanceof AssetFieldWithDefinition) {
            return (AssetFieldWithDefinition)field.get();
        }
        return null;
    }

    protected void updateConfigurableValuesOfField(AssetFieldDefinition definition, GenericFieldSetting setting) {
        String visible;
        super.updateConfigurableValuesOfField((ConfigurableField)definition, setting);
        if (definition instanceof AssetFieldWithDefinition) {
            Boolean mandatory = Boolean.valueOf(setting.getSpecificProperty("prop_mandatory"));
            ((AssetFieldWithDefinition)definition).setMandatory(mandatory);
            Boolean defaultAppliesToNull = Boolean.valueOf(setting.getSpecificProperty("prop_default_replaces_null"));
            ((AssetFieldWithDefinition)definition).setDefaultValueAppliesToNull(defaultAppliesToNull);
        }
        if ((visible = setting.getSpecificProperty("prop_visible_if")) != null) {
            List allowedTypes = (List)new Json().fromJson(visible, (Type)new JsonParameterizedType(List.class, new Type[]{new JsonParameterizedType(List.class, new Type[]{String.class})}));
            List<Integer> types = allowedTypes.stream().map(str -> {
                try {
                    return Integer.valueOf((String)str.get(0));
                }
                catch (NumberFormatException e) {
                    InventoryServerPlugin.LOGGER.warn((Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            definition.setVisibleIfTypeIs(types);
        }
        definition.updateSettings();
    }

    protected void deleteFields(List<AssetFieldWithDefinition<?>> fieldsToDelete) {
        AssetManager.getInstance().maintenance().deleteValuesOfDeletedFields(fieldsToDelete);
    }

    protected boolean fieldSettingOnlyContainsSimpleChanges(GenericFieldSetting setting, GenericFieldSetting updatedSetting) {
        boolean ok = super.fieldSettingOnlyContainsSimpleChanges(setting, updatedSetting);
        if (!ok) {
            return false;
        }
        if (!InventoryGenericFieldsStructureProvider.FIELD_UPDATE_IS_ONLY_ADDED_OR_REMOVED_TYPE.get().booleanValue() && !Objects.equals(setting.getSpecificProperty("prop_visible_if"), updatedSetting.getSpecificProperty("prop_visible_if"))) {
            return false;
        }
        return Objects.equals(setting.getSpecificProperty("prop_default_replaces_null"), updatedSetting.getSpecificProperty("prop_default_replaces_null"));
    }

    protected void sendExternalSignal(List<AssetFieldWithDefinition<?>> removedInfos, List<AssetFieldWithDefinition<?>> addedInfos) {
        AssetManager.getInstance().maintenance().clearCache();
        ArrayList removedSearchTags = new ArrayList();
        removedInfos.forEach(f -> {
            if (f != null && f.getSearchTag() != null) {
                removedSearchTags.add(f.getSearchTag());
                if (f.hasEntrySearchTag()) {
                    removedSearchTags.add(f.getEntrySearchTag());
                }
            }
        });
        ArrayList addedSearchTags = new ArrayList();
        addedInfos.forEach(f -> {
            if (f != null && f.getSearchTag() != null) {
                addedSearchTags.add(f.getSearchTag());
                if (f.hasEntrySearchTag()) {
                    addedSearchTags.add(f.getEntrySearchTag());
                }
            }
        });
        try {
            this.getManager().getSearchEngine().changeTagsAndReindex(removedSearchTags, addedSearchTags);
        }
        catch (IOException e) {
            InventoryServerPlugin.LOGGER.error((Throwable)e);
        }
    }

    public FieldManager<GUID> getManager() {
        return AssetManager.getInstance();
    }

    public List<ConfigValidationMsg> validate(String key, Map<String, String> properties, boolean willBeNewField) {
        List validate = super.validate(key, properties, willBeNewField);
        if (willBeNewField && validate.isEmpty()) {
            List list2;
            List list = DynamicExtensionManager.getInstance().get(AssetField.class);
            if (list.stream().anyMatch(d -> Objects.equals(d.getKey(), key))) {
                validate.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, BASE_TRANSLATIONS.getMsg("fields.validation.reservedkey", new Object[]{key}), "fieldsettingsKey"));
            }
            if ((list2 = DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class)).stream().anyMatch(d -> Objects.equals(d.getFieldKey(), key))) {
                validate.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, BASE_TRANSLATIONS.getMsg("fields.validation.reservedkey", new Object[]{key}), "fieldsettingsKey"));
            }
        }
        SqlQuerySelectValueProvider.validateSQLQuery(properties, (List)validate);
        String typeStr = properties.get("type");
        if (typeStr != null) {
            FieldSettingsType type = FieldSettingsType.valueOf((String)typeStr);
            if (AssetFields.isOpenField(key) && type == FieldSettingsType.TYPE_LINK) {
                validate.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, TicketFieldSettingsManager.MSG.getMsg("fields.validation.openFieldCannotBeLink", new Object[]{type.getLabel()}), "type"));
            }
        }
        return validate;
    }

    public void deleteCustomSetting(String key) {
        if (AssetFields.isOpenField(key)) {
            throw new IllegalArgumentException("Cannot delete open field 1-9");
        }
        super.deleteCustomSetting(key);
    }
}

