/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.handler;

import com.inet.helpdesk.plugins.inventory.client.data.MoveAssetRequest;
import com.inet.helpdesk.plugins.inventory.client.handler.AbstractInventoryHandler;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.AssetNodeIdentifier;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class MoveAssets
extends AbstractInventoryHandler<MoveAssetRequest, Void> {
    public String getMethodName() {
        return "inventory.moveassets";
    }

    @Override
    public Void handle(HttpServletRequest req, HttpServletResponse resp, MoveAssetRequest payload) throws IOException {
        if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_READ_WRITE)) {
            throw new AccessDeniedException(InventoryServerPlugin.INVENTORY_READ_WRITE);
        }
        try {
            GUID guid;
            AssetNodeIdentifier identifier = AssetNodeIdentifier.valueOf(payload.getParentId());
            GUID newParent = identifier.isDevice() ? identifier.getDeviceId() : null;
            for (String strId : payload.getIds()) {
                guid = GUID.valueOf((String)strId);
                if (guid != null) {
                    AssetManager.getInstance().validateDeviceData(MutableAssetData.ofSingle(AssetFields.FIELD_PARENT, newParent), guid);
                    continue;
                }
                throw new ClientMessageException(InventoryServerPlugin.CLIENT_MSG.getMsg("inventory.assetmenu.move.error", new Object[0]));
            }
            for (String strId : payload.getIds()) {
                guid = GUID.valueOf((String)strId);
                AssetManager.getInstance().updateAsset(guid, MutableAssetData.ofSingle(AssetFields.FIELD_PARENT, newParent));
            }
        }
        catch (IllegalArgumentException e) {
            InventoryServerPlugin.LOGGER.debug((Object)e);
            throw new ClientMessageException(e.getMessage());
        }
        return null;
    }
}

