/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.handler;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.inventory.client.data.DeviceFieldDescription;
import com.inet.helpdesk.plugins.inventory.client.data.InitialDataResponse;
import com.inet.helpdesk.plugins.inventory.client.handler.AbstractInventoryHandler;
import com.inet.helpdesk.plugins.inventory.client.handler.InventoryViewSettings;
import com.inet.helpdesk.plugins.inventory.client.handler.LoadTreeGroupingSettings;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithFieldGroup;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.FieldEditInformation;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class InitialData
extends AbstractInventoryHandler<Void, InitialDataResponse> {
    public InitialData() {
        AssetTypeManager.getInstance().addDataChangeListener(() -> AssetManager.getInstance().view().getTreeClients().forEach((clientId, tc) -> {
            Map<Integer, List<DeviceFieldDescription>> deviceFieldsByTypeId = InitialData.getDeviceFieldsByTypeId();
            Supplier<WebSocketEventData> eventFactory = () -> new WebSocketEventData("inventory.assetfields", (Object)deviceFieldsByTypeId);
            WebSocketEventHandler.getInstance().sendEvent(clientId, eventFactory);
        }));
    }

    public String getMethodName() {
        return "inventory.initialdata";
    }

    @Override
    public InitialDataResponse handle(HttpServletRequest req, HttpServletResponse resp, Void payload) throws IOException {
        String displayType;
        TicketFieldDefinition tfd;
        FieldEditDefinition editDefinition;
        UserAccount currentUser = UserManager.getInstance().getCurrentUserAccount();
        InventoryViewSettings viewSettings = null;
        if (currentUser != null) {
            viewSettings = (InventoryViewSettings)currentUser.getValue(InventoryServerPlugin.USERFIELD_INVENTORY_VIEWSETTINGS);
        }
        boolean canWriteAssets = SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_READ_WRITE);
        boolean canShowAllAssets = SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_ALL);
        Map<Integer, List<DeviceFieldDescription>> deviceFieldsByTypeId = InitialData.getDeviceFieldsByTypeId();
        Map<String, String> defaultValues = this.getDefaultValues();
        List<LocalizedKey> groupings = ((List)LoadTreeGroupingSettings.GROUPING_LIST.get()).stream().sorted((a, b) -> a.getName().compareToIgnoreCase(b.getName())).map(g -> new LocalizedKey(g.getKey().toString(), g.getName())).collect(Collectors.toList());
        boolean identifierFieldAsSelect = false;
        Optional<TicketFieldDefinition> fieldDef = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class).stream().filter(d -> Tickets.FIELD_IDENTIFIER.getKey().equals(d.getFieldKey())).findAny();
        if (fieldDef.isPresent() && (editDefinition = (tfd = fieldDef.get()).getEditDefinition()) != null && ("select".equals(displayType = editDefinition.getDisplayType()) || "selectmulti".equals(displayType) || "selecteditable".equals(displayType))) {
            identifierFieldAsSelect = true;
        }
        HashSet<String> fieldsThatInherit = new HashSet<String>();
        fieldsThatInherit.add(AssetFields.FIELD_OWNER.getKey());
        fieldsThatInherit.add(AssetFields.FIELD_COSTCENTER.getKey());
        fieldsThatInherit.add(AssetFields.FIELD_LOCATION.getKey());
        fieldsThatInherit.add(AssetFields.FIELD_ROOM.getKey());
        String affectedAssetsTag = AssetFields.TICKET_FIELD_AFFECTED_ASSETS.getSearchTag().getDisplayName().replace(" ", "-");
        boolean ticketSupporter = currentUser == null ? false : HDUsersAndGroups.isSupporter((UserAccount)currentUser);
        return new InitialDataResponse(viewSettings, canWriteAssets, canShowAllAssets, deviceFieldsByTypeId, defaultValues, groupings, identifierFieldAsSelect, fieldsThatInherit, affectedAssetsTag, ticketSupporter);
    }

    public static Map<Integer, List<DeviceFieldDescription>> getDeviceFieldsByTypeId() {
        boolean canWriteAssets = SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_READ_WRITE);
        Map<Integer, List<DeviceFieldDescription>> deviceFieldsByTypeId = AssetTypeManager.getInstance().getAll(true).stream().collect(Collectors.toMap(type -> type.getId(), type -> new ArrayList()));
        List deviceFields = DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class);
        deviceFields.sort((a, b) -> {
            int compare = Integer.compare(a.getPriority(), b.getPriority());
            if (compare == 0) {
                compare = String.CASE_INSENSITIVE_ORDER.compare(a.getLabel(), b.getLabel());
            }
            return compare;
        });
        for (AssetFieldDefinition fieldWithDefinition : deviceFields) {
            List<Integer> visibleIfTypeIs;
            LocalizedKey fieldGroup = null;
            if (fieldWithDefinition instanceof AssetFieldWithFieldGroup) {
                AssetFieldWithFieldGroup fieldGroupDefinition = (AssetFieldWithFieldGroup)((Object)fieldWithDefinition);
                fieldGroup = fieldGroupDefinition.getFieldGroup();
            }
            DeviceFieldDescription deviceFieldDescription = new DeviceFieldDescription(fieldWithDefinition.getFieldKey(), fieldWithDefinition.getDisplayType().toString(), fieldWithDefinition.getLabel(), fieldWithDefinition.getDescription(), fieldWithDefinition.getAdditionalProperties(), fieldGroup, !canWriteAssets);
            FieldEditInformation<?> editInformation = fieldWithDefinition.getEditInformation();
            if (editInformation == null) continue;
            if (!editInformation.isEnabled()) {
                deviceFieldDescription.setDisabled(true);
            }
            if ((visibleIfTypeIs = fieldWithDefinition.getVisibleIfTypeIs()).contains(-2)) {
                deviceFieldsByTypeId.entrySet().forEach(entry -> ((List)entry.getValue()).add(deviceFieldDescription));
                continue;
            }
            visibleIfTypeIs.forEach(visibleType -> {
                List fields = (List)deviceFieldsByTypeId.get(visibleType);
                if (fields == null) {
                    return;
                }
                fields.add(deviceFieldDescription);
            });
        }
        return deviceFieldsByTypeId;
    }

    private Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        List deviceFields = DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class);
        for (AssetFieldDefinition fieldDefinition : deviceFields) {
            String serializedValue;
            AssetFieldWithDefinition fieldWithDefinition;
            FieldEditInformation editInformation;
            if (!(fieldDefinition instanceof AssetFieldWithDefinition) || (editInformation = (fieldWithDefinition = (AssetFieldWithDefinition)fieldDefinition).getEditInformation()) == null || (serializedValue = editInformation.serializeValue(null)) == null) continue;
            defaultValues.put(fieldDefinition.getFieldKey(), serializedValue);
        }
        return defaultValues;
    }
}

