/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.event;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.plugins.inventory.client.data.AssetID;
import com.inet.helpdesk.plugins.inventory.client.data.AssetStructureNode;
import com.inet.helpdesk.plugins.inventory.client.data.InitStructureState;
import com.inet.helpdesk.plugins.inventory.client.data.InventoryStructureUpdateData;
import com.inet.helpdesk.plugins.inventory.client.event.AbstractInventoryEvent;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithIcon;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.AssetNodeIdentifier;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.TreeNodeInfo;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.settings.StructureViewSettings;
import com.inet.helpdesk.plugins.inventory.server.api.tree.AssetStructureListener;
import com.inet.helpdesk.plugins.inventory.server.api.tree.AssetTreeUpdateEvent;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.http.websocket.WebSocketConnectionListener;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.http.websocket.WebsocketConnection;
import com.inet.id.GUID;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class InitInventoryStructure
extends AbstractInventoryEvent<InitStructureState> {
    public InitInventoryStructure() {
        WebSocketEventHandler.getInstance().addConnectionListener(new WebSocketConnectionListener(){

            public void connectionOpened(String clientId) {
            }

            public void connectionClosed(String clientId) {
                AssetManager.getInstance().view().unregisterStructureClient(clientId);
            }
        });
    }

    @Override
    public void handleEvent(WebSocketEventHandler eventHandler, WebsocketConnection websocketConnection, InitStructureState payload) throws IOException {
        int itemCount = payload.getItemCount();
        int depth = payload.getDepth();
        boolean flatList = payload.isFlatList();
        boolean listGroupings = payload.isListGroupings();
        boolean listSortingAscending = payload.isListSortingAscending();
        AssetFieldWithDefinition listSortingField = (AssetFieldWithDefinition)AssetFields.getFieldFor(payload.getListSortingField());
        AssetNodeIdentifier nodeId = AssetNodeIdentifier.valueOf(payload.getNodeId());
        StructureViewSettings settings = new StructureViewSettings(depth + 1, flatList, listGroupings, listSortingAscending, listSortingField);
        AssetManager.getInstance().view().registerStructureClient(websocketConnection.getPollingID(), nodeId, settings, itemCount, new AssetStructureListener(){

            @Override
            public void sendChanges(String clientId, AssetNodeIdentifier structureRoot, AssetTreeUpdateEvent changes, List<AssetFieldDefinition> minimalFields) {
                Supplier<WebSocketEventData> eventFactory = () -> {
                    AssetID structureRootId = new AssetID(structureRoot.isDevice(), structureRoot.toString());
                    AssetID parentId = new AssetID(changes.parentNode.isDevice(), changes.parentNode.toString());
                    AssetStructureNode parent = null;
                    Locale threadLocale = ClientLocale.getThreadLocale();
                    TimeZone timeZone = ClientTimezone.getTimeZone();
                    GUID currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID();
                    try (UserAccountScope userScope = UserAccountScope.create((GUID)currentUserAccountID);){
                        TreeNodeInfo nodeInfo = AssetManager.getInstance().view().getNodeInfo(clientId, changes.parentNode, false);
                        if (nodeInfo != null) {
                            AssetView device;
                            String displayName = nodeInfo.getDisplayName();
                            String iconKey = nodeInfo.getIcon() == null ? null : "field=" + EncodingFunctions.encodeUrlParameter((String)nodeInfo.getIcon().getFieldKey()) + "&value=" + EncodingFunctions.encodeUrlParameter((String)nodeInfo.getIcon().getValue());
                            String fieldKey = nodeInfo.getFieldKey();
                            String fieldValue = nodeInfo.getIcon() == null ? "" : nodeInfo.getIcon().getValue();
                            boolean hasChildren = nodeInfo.isHasChildNodes();
                            int numOfMoreNodes = nodeInfo.getNumOfMoreNodes();
                            boolean deleted = nodeInfo.isArchived();
                            boolean dummySearchNode = nodeInfo.isDummySearchNode();
                            AssetNodeIdentifier grandParent = nodeInfo.getParentId();
                            AssetID grandParentId = null;
                            if (grandParent != null) {
                                grandParentId = new AssetID(grandParent.isDevice(), grandParent.toString());
                            }
                            HashMap<String, String> values = new HashMap<String, String>();
                            HashMap<String, String> iconValues = new HashMap<String, String>();
                            if (nodeInfo.isAsset() && (device = AssetManager.getInstance().getAsset(nodeInfo.getId().getDeviceId(), true)) != null) {
                                Integer typeId = device.getValue(AssetFields.FIELD_TYPE);
                                values.put("typeid", typeId == null ? null : typeId.toString());
                                if (minimalFields != null) {
                                    for (AssetFieldDefinition definition : minimalFields) {
                                        values.put(definition.getFieldKey(), definition.getDisplayValue(device));
                                        if (!(definition instanceof AssetFieldWithIcon) || AssetFields.FIELD_TYPE.getKey().equals(definition.getFieldKey())) continue;
                                        iconValues.put(definition.getFieldKey(), ((AssetFieldWithIcon)((Object)definition)).getIconValue(device, (AssetField)((Object)((Object)definition))));
                                    }
                                }
                            }
                            parent = new AssetStructureNode(parentId, grandParentId, displayName, fieldKey, fieldValue, iconKey, hasChildren, numOfMoreNodes, deleted, dummySearchNode, values, iconValues, true);
                        }
                    }
                    List<AssetID> insertAssets = Collections.emptyList();
                    if (changes.insertAssets != null && !changes.insertAssets.isEmpty()) {
                        insertAssets = changes.insertAssets.stream().map(id -> new AssetID(id.isDevice(), id.toString())).collect(Collectors.toList());
                    }
                    Set<AssetStructureNode> changedAssets = Collections.emptySet();
                    if (changes.changedAssets != null && !changes.changedAssets.isEmpty()) {
                        changedAssets = changes.changedAssets.parallelStream().map(deviceId -> {
                            Locale oldLocale = ClientLocale.getThreadLocale();
                            TimeZone oldTimezone = ClientTimezone.getTimeZone();
                            ClientLocale.setThreadLocale((Locale)threadLocale);
                            ClientTimezone.setTimeZone((TimeZone)timeZone);
                            try {
                                AssetStructureNode assetStructureNode;
                                block16: {
                                    TreeNodeInfo nodeInfo;
                                    UserAccountScope userScope;
                                    block14: {
                                        AssetStructureNode assetStructureNode2;
                                        block15: {
                                            userScope = UserAccountScope.create((GUID)currentUserAccountID);
                                            nodeInfo = AssetManager.getInstance().view().getNodeInfo(clientId, (AssetNodeIdentifier)deviceId, false);
                                            if (nodeInfo != null) break block14;
                                            assetStructureNode2 = null;
                                            if (userScope == null) break block15;
                                            userScope.close();
                                        }
                                        return assetStructureNode2;
                                    }
                                    try {
                                        AssetView device;
                                        AssetID id = new AssetID(deviceId.isDevice(), deviceId.toString());
                                        String displayName = nodeInfo.getDisplayName();
                                        String iconKey = nodeInfo.getIcon() == null ? null : "field=" + EncodingFunctions.encodeUrlParameter((String)nodeInfo.getIcon().getFieldKey()) + "&value=" + EncodingFunctions.encodeUrlParameter((String)nodeInfo.getIcon().getValue());
                                        String fieldKey = nodeInfo.getFieldKey();
                                        String fieldValue = nodeInfo.getIcon() == null ? "" : nodeInfo.getIcon().getValue();
                                        boolean hasChildren = nodeInfo.isHasChildNodes();
                                        boolean hasSubAssets = false;
                                        int numOfMoreNodes = nodeInfo.getNumOfMoreNodes();
                                        boolean deleted = nodeInfo.isArchived();
                                        boolean dummySearchNode = nodeInfo.isDummySearchNode();
                                        HashMap<String, String> values = new HashMap<String, String>();
                                        HashMap<String, String> iconValues = new HashMap<String, String>();
                                        values.put(AssetFields.FIELD_NAME.getKey(), displayName);
                                        if (deviceId.isDevice() && (device = AssetManager.getInstance().getAsset(deviceId.getDeviceId(), true)) != null) {
                                            hasSubAssets = !device.getChildAssetIDs().isEmpty();
                                            Integer typeId = device.getValue(AssetFields.FIELD_TYPE);
                                            values.put("typeid", typeId == null ? null : typeId.toString());
                                            if (minimalFields != null) {
                                                for (AssetFieldDefinition definition : minimalFields) {
                                                    values.put(definition.getFieldKey(), definition.getDisplayValue(device));
                                                    if (!(definition instanceof AssetFieldWithIcon) || AssetFields.FIELD_TYPE.getKey().equals(definition.getFieldKey())) continue;
                                                    iconValues.put(definition.getFieldKey(), ((AssetFieldWithIcon)((Object)definition)).getIconValue(device, (AssetField)((Object)((Object)((Object)definition)))));
                                                }
                                            }
                                        }
                                        assetStructureNode = new AssetStructureNode(id, parentId, displayName, fieldKey, fieldValue, iconKey, hasChildren, numOfMoreNodes, deleted, dummySearchNode, values, iconValues, hasSubAssets);
                                        if (userScope == null) break block16;
                                    }
                                    catch (Throwable throwable) {
                                        if (userScope != null) {
                                            try {
                                                userScope.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    userScope.close();
                                }
                                return assetStructureNode;
                            }
                            finally {
                                ClientLocale.setThreadLocale((Locale)oldLocale);
                                ClientTimezone.setTimeZone((TimeZone)oldTimezone);
                            }
                        }).filter(a -> a != null).collect(Collectors.toSet());
                    }
                    List<LocalizedKey> columns = minimalFields == null ? null : minimalFields.stream().sorted((a, b) -> {
                        if (AssetFields.FIELD_NAME.getKey().equals(a.getFieldKey())) {
                            return -1;
                        }
                        if (AssetFields.FIELD_NAME.getKey().equals(b.getFieldKey())) {
                            return 1;
                        }
                        int compare = Integer.compare(a.getPriority(), b.getPriority());
                        if (compare == 0) {
                            compare = String.CASE_INSENSITIVE_ORDER.compare(a.getLabel(), b.getLabel());
                        }
                        return compare;
                    }).map(f -> new LocalizedKey(f.getFieldKey(), f.getLabel())).collect(Collectors.toList());
                    return new WebSocketEventData("inventory.structure.update", (Object)new InventoryStructureUpdateData(structureRootId, parentId, parent, changes.removeOffset, changes.lengthRemoved, changes.insertOffset, insertAssets, changedAssets, changes.initialData, changes.hasMore, columns));
                };
                if (UserManager.getInstance().getCurrentUserAccountID() == null) {
                    return;
                }
                WebSocketEventHandler.getInstance().sendEvent(clientId, eventFactory);
            }

            @Override
            public void sendError(String clientId, Throwable error) {
                WebSocketEventHandler.getInstance().sendEvent(clientId, () -> new WebSocketEventData("inventory.structure.error", (Object)StringFunctions.getUserFriendlyErrorMessage((Throwable)error)));
            }
        });
    }

    public String getEventName() {
        return "inventory.structure.init";
    }
}

