/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.settings.ClientTreeSettings;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

@JsonData
@Schema(description="Request parameters for retrieving the inventory asset tree structure")
public class InventoryTreeRequest {
    @Schema(description="Search query to filter assets in the tree", defaultValue="")
    private String query = "";
    @Schema(description="Maximum depth of the tree to load", defaultValue="1")
    private int depth = 1;
    @Schema(description="Visibility filter for assets ('mine' or 'all')", defaultValue="all")
    private String treeVisibility = ClientTreeSettings.TreeVisibility.all.toString();
    @Schema(description="Filter for asset status ('active', 'all', or 'archived')", defaultValue="active")
    private String treeFilter = ClientTreeSettings.TreeFilter.active.toString();
    @Schema(description="List of field keys to group the tree by")
    private List<String> treeGrouping = Collections.emptyList();

    private InventoryTreeRequest() {
    }

    @Nonnull
    public static InventoryTreeRequest defaultRequest() {
        return new InventoryTreeRequest();
    }

    public String getQuery() {
        return this.query;
    }

    public String getTreeVisibility() {
        return this.treeVisibility;
    }

    public String getTreeFilter() {
        return this.treeFilter;
    }

    @Nonnull
    public List<String> getGroupingKeys() {
        return this.treeGrouping;
    }

    public int getDepth() {
        return this.depth;
    }
}

