/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.AssetNodeIdentifier;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.TreeNode;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.util.EncodingFunctions;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

@JsonData
@Schema(description="A node in the inventory asset tree structure")
public class InventoryTreeEntry {
    @Schema(description="The unique identifier of the tree node", required=true)
    private String id;
    @Schema(description="The display name of the node", required=true)
    private String name;
    @Schema(description="Whether this node represents a grouping rather than an asset", required=true)
    private boolean isGroupingNode;
    @Schema(description="The URL to the icon representing this node")
    private String iconUrl;
    @Schema(description="Whether the asset at this node is archived", defaultValue="false")
    private boolean isArchived;
    @Schema(description="Whether this is a dummy node created for search results", defaultValue="false")
    private boolean isDummy;
    @Schema(description="List of child nodes under this node")
    private List<InventoryTreeEntry> children = new ArrayList<InventoryTreeEntry>();

    public static InventoryTreeEntry rootNode() {
        InventoryTreeEntry entry = new InventoryTreeEntry();
        entry.isGroupingNode = true;
        return entry;
    }

    public static InventoryTreeEntry from(TreeNode node) {
        InventoryTreeEntry entry = new InventoryTreeEntry();
        AssetNodeIdentifier identifier = node.getId();
        entry.id = identifier.toString();
        entry.isGroupingNode = !identifier.isDevice();
        entry.name = node.getDisplayName();
        if (node.getIcon() != null) {
            HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
            String contextPath = httpServletRequest == null ? "" : ProxyHttpServletRequest.getContextPath((HttpServletRequest)httpServletRequest);
            entry.iconUrl = contextPath + ("/api?method=inventory.asseticon&&size=128&field=" + EncodingFunctions.encodeUrlParameter((String)node.getIcon().getFieldKey()) + "&value=" + EncodingFunctions.encodeUrlParameter((String)node.getIcon().getValue())).toString();
        }
        entry.isDummy = node.isSearchDummy();
        entry.isArchived = identifier.isDevice() && node.isArchived();
        return entry;
    }

    public void addChild(InventoryTreeEntry treeEntry) {
        this.children.add(treeEntry);
    }

    public List<InventoryTreeEntry> getChildren() {
        return this.children;
    }
}

