/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeVO;
import com.inet.helpdesk.plugins.inventory.server.webapi.data.InventoryAssetType;
import com.inet.id.GUID;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@Schema(description="Basic information about an inventory asset")
public class InventoryAssetEntry {
    @Schema(description="The unique identifier of the asset", required=true)
    private GUID id;
    @Schema(description="The identifier of the parent asset")
    private GUID parent;
    @Schema(description="The identifier of the asset owner")
    @JsonExcludeNull
    private GUID owner;
    @Schema(description="The name of the asset", required=true)
    private String name;
    @Schema(description="Whether the asset is archived", defaultValue="false")
    private boolean isArchived;
    @Schema(description="The type information of the asset", required=true)
    private InventoryAssetType type;
    @Schema(description="The image identifier or URL associated with the asset")
    @JsonExcludeNull
    private String image;

    @Nonnull
    public InventoryAssetEntry fillWith(AssetView asset) {
        AssetTypeVO type = (AssetTypeVO)AssetTypeManager.getInstance().get(asset.getType());
        return this.fillWith(asset, type);
    }

    @Nonnull
    public InventoryAssetEntry fillWith(@Nonnull AssetView asset, @Nullable AssetTypeVO type) {
        this.id = asset.getId();
        this.name = asset.getName();
        this.type = InventoryAssetType.from(type);
        this.parent = asset.getParentID();
        this.image = asset.getValue(AssetFields.FIELD_IMAGE);
        this.isArchived = asset.isArchived();
        return this;
    }

    @Nonnull
    public InventoryAssetEntry addOwner(@Nonnull AssetView asset) {
        this.owner = asset.getOwner();
        return this;
    }

    @Nonnull
    public static InventoryAssetEntry from(AssetView asset) {
        return new InventoryAssetEntry().fillWith(asset);
    }

    @Nonnull
    public static InventoryAssetEntry from(@Nonnull AssetView asset, @Nullable AssetTypeVO type) {
        return new InventoryAssetEntry().fillWith(asset, type);
    }
}

