/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.asset;

import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeVO;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.helpdesk.plugins.inventory.server.webapi.InventoryWebAPIExtension;
import com.inet.helpdesk.plugins.inventory.server.webapi.asset.InventoryAssetArchivalHandler;
import com.inet.helpdesk.plugins.inventory.server.webapi.asset.InventoryAssetAttachmentsHandler;
import com.inet.helpdesk.plugins.inventory.server.webapi.asset.InventoryAssetHistoryHandler;
import com.inet.helpdesk.plugins.inventory.server.webapi.data.InventoryAssetResponse;
import com.inet.helpdesk.plugins.inventory.server.webapi.util.InventoryWebAPIHelper;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import com.inet.plugin.webapi.api.handler.RequestHandlerWithGUIDPathToken;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@Tag(name="Inventory", description="Operations for managing inventory assets")
public class InventoryAssetHandler
extends RequestHandlerWithGUIDPathToken<Map<String, Object>, InventoryAssetResponse> {
    public InventoryAssetHandler() {
        super(new String[]{"asset"});
        this.registerRequestHandler((RequestHandlerBase)new InventoryAssetHistoryHandler());
        this.registerRequestHandler((RequestHandlerBase)new InventoryAssetArchivalHandler("archive"));
        this.registerRequestHandler((RequestHandlerBase)new InventoryAssetArchivalHandler("unarchive"));
        this.registerRequestHandler((RequestHandlerBase)new InventoryAssetArchivalHandler("unarchiveall"));
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            this.registerRequestHandler((RequestHandlerBase)new InventoryAssetAttachmentsHandler());
        }
    }

    public String getHelpPageKey() {
        return "webapi.inventory.asset";
    }

    @Operation(summary="Get or update an asset", description="Retrieves details of a specific inventory asset by its GUID. If update data is provided and the user has write permissions, the asset will be updated.", responses={@ApiResponse(responseCode="200", description="Asset details retrieved or updated successfully", content={@Content(schema=@Schema(implementation=InventoryAssetResponse.class))}), @ApiResponse(responseCode="400", description="Invalid asset ID or asset not found"), @ApiResponse(responseCode="401", description="User not authorized to access asset"), @ApiResponse(responseCode="403", description="User does not have write permissions for updating asset")})
    public InventoryAssetResponse handle(HttpServletRequest request, HttpServletResponse response, @Parameter(description="Asset data to update") @Nullable Map<String, Object> updateData, @Parameter(description="GUID of the asset to retrieve or update") @Nullable GUID assetId, boolean previewModeEnabled) throws IOException {
        if (assetId == null) {
            throw new ClientMessageException(InventoryWebAPIExtension.MSG.getMsg("asset.id.notGiven", new Object[0]));
        }
        AssetManager manager = AssetManager.getInstance();
        AssetView asset = manager.getAsset(assetId, true);
        if (asset == null) {
            throw new ClientMessageException(InventoryWebAPIExtension.MSG.getMsg("asset.id.notFound", new Object[0]));
        }
        if (updateData != null) {
            if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_READ_WRITE)) {
                throw new AccessDeniedException(InventoryServerPlugin.INVENTORY_READ_WRITE);
            }
            if (!previewModeEnabled) {
                MutableAssetData dataToChange = InventoryWebAPIHelper.prepareAssetData(updateData, (AssetTypeVO)AssetTypeManager.getInstance().get(asset.getType()));
                List<AssetManager.AdditionalTask> extensionTasks = InventoryWebAPIHelper.checkAttachmentsUpdateRequest(request, updateData);
                if (!dataToChange.isEmpty() || !extensionTasks.isEmpty()) {
                    manager.updateAsset(assetId, dataToChange, extensionTasks);
                    asset = manager.getAsset(assetId, true);
                }
            }
        }
        return InventoryAssetResponse.from(asset);
    }
}

