/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.taskplanner.action.addaffectedasset;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.ticket.AffectedAssets;
import com.inet.helpdesk.plugins.inventory.server.ticket.ChangeAffectedAssetsExtension;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholderUtils;
import com.inet.id.GUID;
import com.inet.taskplanner.server.api.action.PlaceholderResolver;
import com.inet.taskplanner.server.api.action.ResultAction;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AddAffectedAssetAction
extends ResultAction {
    @Nonnull
    private final String ticketIdsExpr;
    @Nonnull
    private final String assetIdExpr;
    @Nullable
    private final GUID taskID;

    public AddAffectedAssetAction(@Nonnull String ticketIdsExpr, @Nonnull String assetIdExpr, @Nullable GUID taskID) {
        this.ticketIdsExpr = ticketIdsExpr;
        this.assetIdExpr = assetIdExpr;
        this.taskID = taskID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handle(List<JobResultContainer> results) throws TaskExecutionException {
        this.setProgress(0);
        try {
            String resolvedAssetId = this.assetIdExpr;
            if (this.taskID != null) {
                PlaceholderResolver resolver = new PlaceholderResolver(this.assetIdExpr);
                for (int i = 0; i < results.size(); ++i) {
                    if (results.get(i) == null || results.get(i).getMetaProperties() == null) continue;
                    resolver.addMetaData(results.get(i).getMetaProperties());
                }
                resolvedAssetId = resolver.resolve();
            }
            List ticketIds = HDPlaceholderUtils.getTicketIds((String)this.ticketIdsExpr);
            ArrayList<Exception> errors = new ArrayList<Exception>();
            for (Integer ticketId : ticketIds) {
                try {
                    WithAdditionalReaStepData marker = WithAdditionalReaStepData.create((ReaStepField)AssetFields.FIELD_INVENTORY_ASSETID, (Object)GUID.valueOf((String)resolvedAssetId));
                    try {
                        MutableReaStepData rea = new MutableReaStepData();
                        ExtensionArguments ext = ExtensionArguments.ofSingleArg(ChangeAffectedAssetsExtension.EXTARG_AFFECTED_ASSETS, (Object)new AffectedAssets(GUID.valueOf((String)resolvedAssetId)));
                        TicketManager.getManipulator().applyAction(ticketId.intValue(), rea, ReaStepTextVO.empty(), (ActionVO)ActionManager.getInstance().get(-39), ext);
                    }
                    finally {
                        if (marker == null) continue;
                        marker.close();
                    }
                }
                catch (Exception e) {
                    errors.add(e);
                }
            }
            if (!errors.isEmpty()) {
                throw new TaskExecutionException((Throwable)errors.get(0));
            }
        }
        finally {
            this.setProgress(100);
        }
    }
}

