/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.config;

import com.inet.classloader.I18nMessages;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.config.structure.provider.ConfigValidator;
import com.inet.helpdesk.config.TicketValueIconConfigProperty;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.utils.TicketValuesImageResolver;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.license.AssetLicense;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.license.AssetLicenseManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.sla.AssetSLA;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.sla.AssetSLAManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeVO;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.vendor.AssetVendor;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.vendor.AssetVendorManager;
import com.inet.helpdesk.plugins.inventory.server.config.AssetFieldSettingsProperty;
import com.inet.helpdesk.plugins.inventory.server.config.generics.LicenseListConfigProperty;
import com.inet.helpdesk.plugins.inventory.server.config.generics.SlaListConfigProperty;
import com.inet.helpdesk.plugins.inventory.server.config.generics.TypeListConfigProperty;
import com.inet.helpdesk.plugins.inventory.server.config.generics.VendorListConfigProperty;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InventoryGenericFieldsStructureProvider
extends AbstractStructureProvider {
    public static final String GROUP_DEVICES = "group.devices";
    public static final String CATEGORY_TYPES = "category.device.types";
    private static final String PROP_GROUP_TYPES_TITLE_LABEL = "prop.device.types.label";
    private static final String PROP_GROUP_TYPES = "prop.device.types";
    public static final String CATEGORY_LICENSES = "category.device.licenses";
    private static final String PROP_GROUP_LICENSES_TITLE_LABEL = "prop.device.licenses.label";
    private static final String PROP_GROUP_LICENSES = "prop.device.licenses";
    public static final String CATEGORY_SLAS = "category.device.slas";
    private static final String PROP_GROUP_SLAS_TITLE_LABEL = "prop.device.slas.label";
    private static final String PROP_GROUP_SLAS = "prop.device.slas";
    public static final String CATEGORY_VENDORS = "category.device.vendors";
    private static final String PROP_GROUP_VENDORS_TITLE_LABEL = "prop.device.vendors.label";
    private static final String PROP_GROUP_VENDORS = "prop.device.vendors";
    public static final int TYPE_ASSET_LICENSE = 15;
    public static final int TYPE_ASSET_VENDOR = 16;
    public static final int TYPE_ASSET_SLA = 17;
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.plugins.inventory.server.config.i18n.ConfigStructure", AssetFieldSettingsProperty.class);
    public static final ThreadLocal<Boolean> FIELD_UPDATE_IS_ONLY_ADDED_OR_REMOVED_TYPE = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        groups.add(new ConfigGroup(410, GROUP_DEVICES, this.translate(settings, GROUP_DEVICES, new Object[0])));
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (groupKey) {
            case "group.devices": {
                categories.add(new ConfigCategory(132, CATEGORY_TYPES, this.translate(settings, "category.types", new Object[0]), "assets.types"));
                categories.add(new ConfigCategory(133, CATEGORY_LICENSES, this.translate(settings, "category.licenses", new Object[0]), "assets.licenses"));
                categories.add(new ConfigCategory(134, CATEGORY_SLAS, this.translate(settings, "category.slas", new Object[0]), "assets.slas"));
                categories.add(new ConfigCategory(135, CATEGORY_VENDORS, this.translate(settings, "category.vendors", new Object[0]), "assets.vendors"));
            }
        }
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        try {
            switch (categoryKey) {
                case "category.device.types": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/images/config_category_types.png");
                }
                case "category.device.licenses": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/images/config_category_licenses.png");
                }
                case "category.device.slas": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/images/config_category_sla.png");
                }
                case "category.device.vendors": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/images/config_category_vendors.png");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> configPropertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.device.types": {
                configPropertyGroups.add(new ConfigPropertyGroup(121, PROP_GROUP_TYPES_TITLE_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_TYPES));
                break;
            }
            case "category.device.licenses": {
                configPropertyGroups.add(new ConfigPropertyGroup(121, PROP_GROUP_LICENSES_TITLE_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_LICENSES));
                break;
            }
            case "category.device.slas": {
                configPropertyGroups.add(new ConfigPropertyGroup(121, PROP_GROUP_SLAS_TITLE_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_SLAS));
                break;
            }
            case "category.device.vendors": {
                configPropertyGroups.add(new ConfigPropertyGroup(121, PROP_GROUP_VENDORS_TITLE_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_VENDORS));
                break;
            }
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "prop.device.types": {
                configProperties.add((ConfigProperty)new TypeListConfigProperty(settings, t -> this.translate(settings, t[0], new Object[0])));
                break;
            }
            case "prop.device.types.label": {
                this.addTo(configProperties, PROP_GROUP_TYPES_TITLE_LABEL, "Label", settings);
                break;
            }
            case "prop.device.licenses": {
                configProperties.add((ConfigProperty)new LicenseListConfigProperty(settings, t -> this.translate(settings, t[0], new Object[0])));
                break;
            }
            case "prop.device.licenses.label": {
                this.addTo(configProperties, PROP_GROUP_LICENSES_TITLE_LABEL, "Label", settings);
                break;
            }
            case "prop.device.slas": {
                configProperties.add((ConfigProperty)new SlaListConfigProperty(settings, t -> this.translate(settings, t[0], new Object[0])));
                break;
            }
            case "prop.device.slas.label": {
                this.addTo(configProperties, PROP_GROUP_SLAS_TITLE_LABEL, "Label", settings);
                break;
            }
            case "prop.device.vendors": {
                configProperties.add((ConfigProperty)new VendorListConfigProperty(settings, t -> this.translate(settings, t[0], new Object[0])));
                break;
            }
            case "prop.device.vendors.label": {
                this.addTo(configProperties, PROP_GROUP_VENDORS_TITLE_LABEL, "Label", settings);
            }
        }
    }

    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        Object changedValueRaw;
        ConfigValidator validator = new ConfigValidator(messages, settings);
        if (CATEGORY_TYPES.equals(categoryKey) && (changedValueRaw = (List)settings.getChangedValue("DeviceTypes", List.class)) != null) {
            if (changedValueRaw.isEmpty()) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "field.type.validate.oneMustExist", new Object[0]), "DeviceTypes"));
            }
            AssetTypeManager m = AssetTypeManager.getInstance();
            List all = m.getAll(false);
            ArrayList ids = new ArrayList(all.stream().map(FieldVO::getId).collect(Collectors.toList()));
            Iterator iterator = changedValueRaw.iterator();
            while (iterator.hasNext()) {
                Map c = (Map)iterator.next();
                String id = (String)c.get("id");
                ids.remove(Integer.valueOf(id));
            }
            ids.forEach(i -> {
                Set simpleSearch = AssetManager.getInstance().getSearchEngine().simpleSearch(new SearchCommand(new SearchExpression[]{new SearchCondition(AssetFields.FIELD_TYPE.getKey(), SearchCondition.SearchTermOperator.Equals, i)}));
                if (!simpleSearch.isEmpty()) {
                    String displayValue = ((AssetTypeVO)m.get((int)i)).getDisplayValue();
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "field.type.validate.typeStillUsed", new Object[]{displayValue}), "DeviceTypes"));
                }
            });
        }
        if (categoryKey != null) {
            List changedValueRaw2;
            switch (categoryKey) {
                case "license.new": {
                    String ser;
                    validator.validateStringLength("name", 1, 50);
                    validator.validateStringLength("bezeichnung", 1, 50);
                    validator.validateStringLength("bemerkung", 0, 2000);
                    validator.validateStringLength("produkt", 1, 50);
                    String cl = settings.getValue("clientanzahl");
                    if (!StringFunctions.isEmpty((String)cl)) {
                        validator.validateNumberRange("clientanzahl", cl, 0L, Integer.MAX_VALUE);
                    }
                    if (StringFunctions.isEmpty((String)(ser = settings.getValue("serveranzahl")))) break;
                    validator.validateNumberRange("serveranzahl", ser, 0L, Integer.MAX_VALUE);
                    break;
                }
                case "type.new": {
                    validator.validateStringLength("name", 1, 50);
                    break;
                }
                case "vendor.new": {
                    validator.validateStringLength("name", 1, 50);
                    validator.validateStringLength("email", 0, 50);
                    validator.validateStringLength("phone", 0, 50);
                    validator.validateStringLength("fax", 0, 50);
                    validator.validateStringLength("address", 0, 500);
                    validator.validateStringLength("rma", 0, 500);
                    break;
                }
                case "sla.new": {
                    validator.validateStringLength("name", 1, 50);
                    validator.validateStringLength("agreement", 0, 500);
                }
            }
            String listKey = null;
            switch (categoryKey) {
                case "category.device.types": {
                    listKey = "DeviceTypes";
                    break;
                }
                case "category.device.licenses": {
                    listKey = "DeviceLicenses";
                    break;
                }
                case "category.device.slas": {
                    listKey = "DeviceSla";
                    break;
                }
                case "category.device.vendors": {
                    listKey = "DeviceVendors";
                    break;
                }
            }
            if (listKey != null && (changedValueRaw2 = (List)settings.getChangedValue(listKey, List.class)) != null) {
                HashSet<String> duplicated = new HashSet<String>();
                for (Map map : changedValueRaw2) {
                    String name1 = (String)map.get("name");
                    for (Map map2 : changedValueRaw2) {
                        String name2;
                        if (map == map2 || !Objects.equals(name1, name2 = (String)map2.get("name")) || duplicated.contains(name1)) continue;
                        duplicated.add(name1);
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "field.validate.nameIsAlreadyUsed", new Object[]{name1}), listKey));
                    }
                }
            }
        }
    }

    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        List changedValueRaw;
        if (key.equals("DeviceTypes") && (changedValueRaw = (List)settings.getChangedValue("DeviceTypes", List.class)) != null) {
            List serializedImageData = TicketValueIconConfigProperty.getSerializedImageData((List)changedValueRaw);
            AssetTypeManager m = AssetTypeManager.getInstance();
            List all = m.getAll(false);
            ArrayList ids = new ArrayList(all.stream().map(FieldVO::getId).collect(Collectors.toList()));
            for (Map c : changedValueRaw) {
                String id = (String)c.get("id");
                String name = (String)c.get("name");
                String icon = (String)c.get("image");
                String enabledFields = (String)c.get("enabledFields");
                boolean duplicate = Boolean.parseBoolean((String)c.get("duplicate"));
                try {
                    int id_int = Integer.valueOf(id);
                    if (id_int == -1 || duplicate) {
                        id_int = m.add(new AssetTypeVO(name, icon));
                        FIELD_UPDATE_IS_ONLY_ADDED_OR_REMOVED_TYPE.set(Boolean.TRUE);
                    } else {
                        ids.remove((Object)id_int);
                        m.update(new AssetTypeVO(id_int, name, icon));
                    }
                    String relativePath = TicketValueIconConfigProperty.storeIcons((List)serializedImageData, (int)14, (int)id_int, (String)icon);
                    if (relativePath != null) {
                        m.update(new AssetTypeVO(id_int, name, relativePath));
                    }
                    TypeListConfigProperty.saveEnabledFieldsFor(enabledFields, id_int);
                }
                catch (SQLException e) {
                    HDLogger.error((Object)e);
                    throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                }
                finally {
                    FIELD_UPDATE_IS_ONLY_ADDED_OR_REMOVED_TYPE.set(Boolean.FALSE);
                }
            }
            ids.forEach(i -> {
                try {
                    AssetTypeVO removed = (AssetTypeVO)m.remove((int)i);
                    if (removed != null) {
                        String iconPath = removed.getSymbol();
                        if (iconPath != null) {
                            List availableSizes = TicketValuesImageResolver.getInstance().getAvailableSizes(iconPath);
                            for (Integer size : availableSizes) {
                                TicketValuesImageResolver.getInstance().removeIcon(iconPath, size.intValue());
                            }
                        }
                        FIELD_UPDATE_IS_ONLY_ADDED_OR_REMOVED_TYPE.set(Boolean.TRUE);
                        TypeListConfigProperty.saveEnabledFieldsFor(TypeListConfigProperty.toJson(Collections.emptyList()), i);
                    }
                }
                catch (SQLException e) {
                    HDLogger.error((Object)e);
                    throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                }
                finally {
                    FIELD_UPDATE_IS_ONLY_ADDED_OR_REMOVED_TYPE.set(Boolean.FALSE);
                }
            });
            return ConfigStructure.SaveState.SAVE;
        }
        if (key.equals("DeviceLicenses") && (changedValueRaw = (List)settings.getChangedValue("DeviceLicenses", List.class)) != null) {
            List serializedImageData = TicketValueIconConfigProperty.getSerializedImageData((List)changedValueRaw);
            AssetLicenseManager m = AssetLicenseManager.getInstance();
            List all = m.getAll(false);
            ArrayList ids = new ArrayList(all.stream().map(FieldVO::getId).collect(Collectors.toList()));
            for (Map c : changedValueRaw) {
                String id = (String)c.get("id");
                String name = (String)c.get("name");
                String label = (String)c.get("bezeichnung");
                String note = (String)c.get("bemerkung");
                String product = (String)c.get("produkt");
                String client = (String)c.get("clientanzahl");
                String server = (String)c.get("serveranzahl");
                String purchaseDate = (String)c.get("erwerbsdatum");
                boolean duplicate = Boolean.parseBoolean((String)c.get("duplicate"));
                try {
                    String oldIconPath;
                    int id_int = Integer.valueOf(id);
                    String string = oldIconPath = duplicate ? "data/15/" + id_int : null;
                    if (id_int == -1 || duplicate) {
                        id_int = m.add(new AssetLicense(-1, name, label, product, note, InventoryGenericFieldsStructureProvider.fromString(purchaseDate, Long::valueOf), InventoryGenericFieldsStructureProvider.fromString(client, Integer::valueOf), InventoryGenericFieldsStructureProvider.fromString(server, Integer::valueOf), false));
                    } else {
                        ids.remove((Object)id_int);
                        m.update(new AssetLicense(id_int, name, label, product, note, InventoryGenericFieldsStructureProvider.fromString(purchaseDate, Long::valueOf), InventoryGenericFieldsStructureProvider.fromString(client, Integer::valueOf), InventoryGenericFieldsStructureProvider.fromString(server, Integer::valueOf), false));
                    }
                    TicketValueIconConfigProperty.storeIcons((List)serializedImageData, (int)15, (int)id_int, (String)oldIconPath);
                }
                catch (SQLException e) {
                    HDLogger.error((Object)e);
                    throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                }
            }
            ids.forEach(i -> {
                try {
                    AssetLicense x = (AssetLicense)m.get((int)i);
                    m.update(new AssetLicense(x.getId(), x.getKurzBezeichnung(), x.getBezeichnung(), x.getProdukt(), x.getBemerkung(), x.getErwerbsDatum(), x.getClientAnzahl(), x.getServerAnzahl(), true));
                }
                catch (SQLException e) {
                    HDLogger.error((Object)e);
                    throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                }
            });
            return ConfigStructure.SaveState.SAVE;
        }
        if (key.equals("DeviceSla") && (changedValueRaw = (List)settings.getChangedValue("DeviceSla", List.class)) != null) {
            List serializedImageData = TicketValueIconConfigProperty.getSerializedImageData((List)changedValueRaw);
            AssetSLAManager m = AssetSLAManager.getInstance();
            List all = m.getAll(false);
            ArrayList ids = new ArrayList(all.stream().map(FieldVO::getId).collect(Collectors.toList()));
            for (Map c : changedValueRaw) {
                String id = (String)c.get("id");
                String name = (String)c.get("name");
                String agreement = (String)c.get("agreement");
                String resource = (String)c.get("resource");
                boolean duplicate = Boolean.parseBoolean((String)c.get("duplicate"));
                try {
                    String oldIconPath;
                    int id_int = Integer.valueOf(id);
                    String string = oldIconPath = duplicate ? "data/17/" + id_int : null;
                    if (id_int == -1 || duplicate) {
                        id_int = m.add(new AssetSLA(-1, name, agreement, InventoryGenericFieldsStructureProvider.fromString(resource, Integer::valueOf), false));
                    } else {
                        ids.remove((Object)id_int);
                        m.update(new AssetSLA(id_int, name, agreement, InventoryGenericFieldsStructureProvider.fromString(resource, Integer::valueOf), false));
                    }
                    TicketValueIconConfigProperty.storeIcons((List)serializedImageData, (int)17, (int)id_int, (String)oldIconPath);
                }
                catch (SQLException e) {
                    HDLogger.error((Object)e);
                    throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                }
            }
            ids.forEach(i -> {
                try {
                    AssetSLA x = (AssetSLA)m.get((int)i);
                    m.update(new AssetSLA(x.getId(), x.getBezeichnung(), x.getSLA(), x.getResID(), true));
                }
                catch (SQLException e) {
                    HDLogger.error((Object)e);
                    throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                }
            });
            return ConfigStructure.SaveState.SAVE;
        }
        if (key.equals("DeviceVendors") && (changedValueRaw = (List)settings.getChangedValue("DeviceVendors", List.class)) != null) {
            List serializedImageData = TicketValueIconConfigProperty.getSerializedImageData((List)changedValueRaw);
            AssetVendorManager m = AssetVendorManager.getInstance();
            List all = m.getAll(false);
            ArrayList ids = new ArrayList(all.stream().map(FieldVO::getId).collect(Collectors.toList()));
            for (Map c : changedValueRaw) {
                String id = (String)c.get("id");
                String name = (String)c.get("name");
                String email = (String)c.get("email");
                String phone = (String)c.get("phone");
                String fax = (String)c.get("fax");
                String address = (String)c.get("address");
                String rma = (String)c.get("rma");
                boolean duplicate = Boolean.parseBoolean((String)c.get("duplicate"));
                try {
                    String oldIconPath;
                    int id_int = Integer.valueOf(id);
                    String string = oldIconPath = duplicate ? "data/16/" + id_int : null;
                    if (id_int == -1 || duplicate) {
                        id_int = m.add(new AssetVendor(-1, name, phone, email, fax, address, rma, false));
                    } else {
                        ids.remove((Object)id_int);
                        m.update(new AssetVendor(id_int, name, phone, email, fax, address, rma, false));
                    }
                    TicketValueIconConfigProperty.storeIcons((List)serializedImageData, (int)16, (int)id_int, (String)oldIconPath);
                }
                catch (SQLException e) {
                    HDLogger.error((Object)e);
                    throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                }
            }
            ids.forEach(i -> {
                try {
                    AssetVendor x = (AssetVendor)m.get((int)i);
                    m.update(new AssetVendor(x.getId(), x.getName(), x.getTelefon(), x.getEMail(), x.getFax(), x.getAdresse(), x.getRMA(), true));
                }
                catch (SQLException e) {
                    HDLogger.error((Object)e);
                    throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                }
            });
            return ConfigStructure.SaveState.SAVE;
        }
        return super.save(key, value, settings);
    }

    public static <T> T fromString(String prop, Function<String, T> f) {
        if (StringFunctions.isEmpty((String)prop)) {
            return null;
        }
        return f.apply(prop);
    }

    @Nonnull
    public @Nonnull Permission @Nonnull [] getRequiredPermissions() {
        return new Permission[]{Permission.CONFIGURATION, InventoryServerPlugin.INVENTORY_ALL, InventoryServerPlugin.INVENTORY_READ_WRITE};
    }
}

