/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts;

import com.inet.field.FieldUtils;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.field.SelectableField;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.field.fieldtypes.HasSelectOptions;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetVO;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithConfigurableDefault;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.FieldEditInformation;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.FieldEditInformation_Select;
import java.util.List;
import java.util.Objects;

public abstract class AssetField_Select<VALUE>
extends AssetFieldWithConfigurableDefault<VALUE>
implements SelectableField,
HasSelectOptions {
    public AssetField_Select(String key, VALUE defaultValue, int sortPrio) {
        super(key, defaultValue, sortPrio, FieldSettingsType.TYPE_SELECT, FieldTypeFactory.custom());
        this.updateSettings();
    }

    protected List<SelectOption> getSelectOptions() {
        return this.getSelectOptions(false);
    }

    public SelectOption getValue(AssetView device) {
        Object value = device != null ? device.getValue(this) : this.getDefaultValue();
        return this.getSelectOptions().stream().filter(op -> Objects.equals(op.getValue(), this.asString(value))).findFirst().orElse(null);
    }

    public SelectOptionResult getOptions(AssetVO device, String searchTerm, int currentSize, int chunkSize) {
        return FieldUtils.getOptions((String)searchTerm, (int)currentSize, (int)chunkSize, this.getSelectOptions());
    }

    @Override
    public FieldEditInformation<VALUE> getEditInformation() {
        return new FieldEditInformation_Select(this);
    }

    public boolean allowsCustomValue() {
        return false;
    }

    public boolean allowsMultipleValues() {
        return false;
    }

    @Override
    public void updateSettings() {
        this.getAdditionalProperties().clear();
        if (this.allowsMultipleValues()) {
            this.addAdditionalProperty("multiselection", "true");
        }
        if (this.allowsCustomValue()) {
            this.addAdditionalProperty("customvalue", "true");
        }
    }
}

