/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts;

import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.FieldEditInformation;
import com.inet.helpdesk.plugins.inventory.server.internal.search.ValueAndDisplayValue;
import com.inet.http.servlet.ClientLocale;
import com.inet.search.command.SearchCondition;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AssetFieldWithDefinition<VALUE>
extends AssetField<VALUE>
implements AssetFieldDefinition {
    private int sortPrio;
    private FieldSettingsType displayType;
    private boolean mandatory;
    private Map<String, String> properties = new HashMap<String, String>();
    private List<Integer> visibleIfTypeIs = Collections.singletonList(-2);

    public AssetFieldWithDefinition(String fieldKey, VALUE defaultvalue, int sortPrio, FieldSettingsType displayType, FieldTypeFactory factory) {
        super(fieldKey, defaultvalue, factory);
        this.sortPrio = sortPrio;
        this.displayType = displayType;
    }

    @Override
    public FieldSettingsType getDisplayType() {
        return this.displayType;
    }

    public String getFieldKey() {
        return this.getFieldType().getKey();
    }

    public void setSortPrio(int prio) {
        this.sortPrio = prio;
    }

    public int getPriority() {
        return this.sortPrio;
    }

    @Override
    public String getLabel() {
        return AssetFieldDefinition.super.getLabel();
    }

    @Override
    public String getDisplayValue(AssetView device) {
        Object value = device.getValue(this);
        if (value == null) {
            return null;
        }
        return this.getDisplayValue(value);
    }

    public VALUE valueOf(String stringRepresentation) {
        return (VALUE)this.getFieldType().valueOf(stringRepresentation);
    }

    @Nullable
    public String asString(VALUE value) {
        return this.getFieldType().asString(value);
    }

    public FieldEditInformation<VALUE> getEditInformation() {
        return new FieldEditInformation(this);
    }

    @Override
    public String createFieldChangeStepText(VALUE oldValue, VALUE newValue) {
        return this.getLabel() + ": " + (oldValue == null ? "" : this.getDisplayValue(oldValue)) + " -> " + (newValue == null ? "" : this.getDisplayValue(newValue));
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    @Override
    public List<Integer> getVisibleIfTypeIs() {
        return this.visibleIfTypeIs;
    }

    @Override
    public void setVisibleIfTypeIs(List<Integer> visibleIfTypeIs) {
        this.visibleIfTypeIs = visibleIfTypeIs;
    }

    @Override
    @Nonnull
    public Map<String, String> getAdditionalProperties() {
        return this.properties;
    }

    public void addAdditionalProperty(@Nonnull String name, @Nonnull String value) {
        this.properties.put(name, value);
    }

    public String getDisplayValue(VALUE value) {
        return this.getFieldType().getDisplayValue(value);
    }

    @Nonnull
    public Comparator<ValueAndDisplayValue<VALUE>> getComparator() {
        Collator comp = Collator.getInstance(ClientLocale.getThreadLocale());
        Comparator<Object> nullsFirst = Comparator.nullsFirst(comp);
        return (a, b) -> {
            int compare = nullsFirst.compare(a.getDisplayValue(), b.getDisplayValue());
            if (compare != 0) {
                return compare;
            }
            return nullsFirst.compare(this.asString(a.getValue()), this.asString(b.getValue()));
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getFieldKey() == null ? 0 : this.getFieldKey().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssetFieldWithDefinition other = (AssetFieldWithDefinition)obj;
        return !(this.getFieldKey() == null ? other.getFieldKey() != null : !this.getFieldKey().equals(other.getFieldKey()));
    }

    public SearchCondition createCondition(String stringRepresentation) {
        return new SearchCondition(this.getEntrySearchKey(), SearchCondition.SearchTermOperator.Equals, this.valueOf(stringRepresentation));
    }
}

