/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model.field;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.field.FieldUtils;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetVO;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithFieldGroup;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithIcon;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_Select_Int;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.vendor.AssetVendor;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.vendor.AssetVendorManager;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.FieldValidationException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class AssetFieldVendor
extends AssetField_Select_Int
implements AssetFieldWithFieldGroup,
AssetFieldWithIcon<Integer> {
    public AssetFieldVendor(String key, int sortPrio) {
        super(key, null, sortPrio);
    }

    public List<SelectOption> getSelectOptions(boolean includeDeleted) {
        List all = AssetVendorManager.getInstance().getAll(!includeDeleted);
        ArrayList arrayList = all.stream().map(dt -> this.selectOption((AssetVendor)((Object)dt))).collect(Collectors.toCollection(ArrayList::new));
        arrayList.add(0, new SelectOption(null, ""));
        return arrayList;
    }

    @Override
    public SelectOptionResult getOptions(AssetVO device, String searchTerm, int currentSize, int chunkSize) {
        HashMap options = new HashMap();
        this.getSelectOptions().forEach(op -> options.put(op.getValue(), op.getLabel()));
        return FieldUtils.getOptions((String)searchTerm, (int)currentSize, (int)chunkSize, options, (value, displayName) -> new SelectOption(StringFunctions.stringValueOf((Object)value), displayName, String.valueOf(value)));
    }

    private SelectOption selectOption(AssetVendor deviceVendorVO) {
        return new SelectOption(String.valueOf(deviceVendorVO.getId()), deviceVendorVO.getDisplayValue(), String.valueOf(deviceVendorVO.getId()));
    }

    @Override
    public SelectOption getValue(AssetView device) {
        AssetVendor assetVendor;
        Integer value = device != null ? device.getValue(this) : (Integer)this.getDefaultValue();
        if (value != null && (assetVendor = (AssetVendor)AssetVendorManager.getInstance().get(value)) != null) {
            return this.selectOption(assetVendor);
        }
        return null;
    }

    @Override
    public void validateRealValue(Integer id) throws FieldValidationException {
        if (id != null && AssetVendorManager.getInstance().get(id) == null) {
            throw new FieldValidationException(AssetManager.MSG.getMsg("manager.error.objectDoesNotExist", new Object[]{id}));
        }
    }

    @Override
    public String getDisplayValue(Integer value) {
        AssetVendor vendor = (AssetVendor)AssetVendorManager.getInstance().get(value);
        if (vendor != null) {
            return vendor.getDisplayValue();
        }
        return null;
    }

    @Override
    public URL getIcon(String value, int size) {
        try {
            int type = Integer.parseInt(value);
            return AssetVendorManager.getInstance().getIcon(type, size);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getIcon(value, size);
        }
    }

    @Override
    @Nullable
    public LocalizedKey getFieldGroup() {
        return new LocalizedKey(this.getFieldKey(), this.getLabel());
    }

    @Override
    public List<AssetFieldWithFieldGroup.AdditionalDetailField> getAdditionalFields(String serializedValue) {
        AssetVendor assetVendor;
        MutableAssetData data = new MutableAssetData();
        this.getEditInformation().updateAssetData(data, serializedValue);
        Integer value = data.get(this);
        AssetVendor assetVendor2 = assetVendor = value == null ? null : (AssetVendor)AssetVendorManager.getInstance().get(value);
        if (assetVendor == null) {
            return null;
        }
        ArrayList<AssetFieldWithFieldGroup.AdditionalDetailField> fields = new ArrayList<AssetFieldWithFieldGroup.AdditionalDetailField>();
        fields.add(new AssetFieldWithFieldGroup.AdditionalDetailField("email", 1, false, InventoryServerPlugin.CONFIG_MSG.getMsg("field.vendor.row.email", new Object[0]), assetVendor.getEMail()));
        fields.add(new AssetFieldWithFieldGroup.AdditionalDetailField("telephone", 2, false, InventoryServerPlugin.CONFIG_MSG.getMsg("field.vendor.row.phone", new Object[0]), assetVendor.getTelefon()));
        fields.add(new AssetFieldWithFieldGroup.AdditionalDetailField("fax", 3, false, InventoryServerPlugin.CONFIG_MSG.getMsg("field.vendor.row.fax", new Object[0]), assetVendor.getFax()));
        fields.add(new AssetFieldWithFieldGroup.AdditionalDetailField("address", 4, true, InventoryServerPlugin.CONFIG_MSG.getMsg("field.vendor.row.address", new Object[0]), assetVendor.getAdresse()));
        fields.add(new AssetFieldWithFieldGroup.AdditionalDetailField("rma", 5, true, InventoryServerPlugin.CONFIG_MSG.getMsg("field.vendor.row.rma", new Object[0]), assetVendor.getRMA()));
        return fields;
    }
}

