/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model.field;

import com.inet.field.FieldUtils;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetVO;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithIcon;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_Select_Int;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.FieldValidationException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class AssetFieldLocation
extends AssetField_Select_Int
implements AssetFieldWithIcon<Integer> {
    public AssetFieldLocation(String key, int sortPrio) {
        super(key, null, sortPrio);
    }

    public List<SelectOption> getSelectOptions(boolean includeDeleted) {
        List all = LocationManager.getInstance().getAll(!includeDeleted);
        ArrayList arrayList = all.stream().map(dt -> this.selectOption((LocationVO)dt)).collect(Collectors.toCollection(ArrayList::new));
        arrayList.add(0, new SelectOption(null, ""));
        return arrayList;
    }

    @Override
    public SelectOptionResult getOptions(AssetVO device, String searchTerm, int currentSize, int chunkSize) {
        HashMap options = new HashMap();
        this.getSelectOptions().forEach(op -> options.put(op.getValue(), op.getLabel()));
        return FieldUtils.getOptions((String)searchTerm, (int)currentSize, (int)chunkSize, options, (value, displayName) -> new SelectOption(StringFunctions.stringValueOf((Object)value), displayName, String.valueOf(value)));
    }

    private SelectOption selectOption(LocationVO locationVO) {
        return new SelectOption(String.valueOf(locationVO.getId()), locationVO.getDisplayValue(), String.valueOf(locationVO.getId()));
    }

    @Override
    public SelectOption getValue(AssetView device) {
        LocationVO locationVO;
        Integer value = device != null ? device.getValue(this) : (Integer)this.getDefaultValue();
        if (value != null && (locationVO = (LocationVO)LocationManager.getInstance().get(value.intValue())) != null) {
            return this.selectOption(locationVO);
        }
        return null;
    }

    @Override
    public void validateRealValue(Integer id) throws FieldValidationException {
        if (id != null && LocationManager.getInstance().get(id.intValue()) == null) {
            throw new FieldValidationException(AssetManager.MSG.getMsg("manager.error.objectDoesNotExist", new Object[]{id}));
        }
    }

    @Override
    public String getDisplayValue(Integer value) {
        LocationVO locationVO = (LocationVO)LocationManager.getInstance().get(value.intValue());
        if (locationVO != null) {
            return locationVO.getDisplayValue();
        }
        return null;
    }

    @Override
    public URL getIcon(String value, int size) {
        try {
            int type = Integer.parseInt(value);
            return LocationManager.getInstance().getIcon(type, size);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getIcon(value, size);
        }
    }
}

